/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.LatLonObject;
import main.java.guru.vfrflight.core.sql.entity.xml.NavaidXml;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.StringUtil;

@Entity
@Table(name="NAVAIDS")
public class Navaid
implements Serializable,
LatLonObject {
    private static final long serialVersionUID = -5908383103408321790L;
    public static final String CREATE_QUERY = "CREATE CACHED TABLE navaids ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), remark VARCHAR(512), ident VARCHAR(16), name VARCHAR(64), type VARCHAR(7), lat DECIMAL(18,15), lon DECIMAL(18,15), freq INTEGER, alt INTEGER, magvar DECIMAL(5,2), PRIMARY KEY (id), country char(2))";
    public static final String SELECT_QUERY = "SELECT id, ident, name, type, lat, lon, freq, alt, country FROM navaids ";
    public static final String DROP_QUERY = "DROP TABLE navaids ";
    private Integer id;
    private String remark;
    private String ident;
    private String name;
    private String type;
    private Double lat;
    private Double lon;
    private Integer alt;
    private Integer freq;
    private String country;
    private String region;
    private Double magvar;

    public Navaid() {
    }

    public Navaid(NavaidXml n) {
        GpsPlace place;
        String[] coords;
        this.alt = n.getElevationInFt();
        this.type = n.getType();
        if (n.getFrequency() != null) {
            this.freq = n.isNdb() ? (int)Math.round(n.getFrequency() * 10.0) : (int)Math.round(n.getFrequency() * 1000.0);
        }
        this.ident = n.getIdent();
        this.name = n.getName();
        this.magvar = n.getMagvar();
        this.remark = n.getRemark();
        if (n.getPos() != null && (coords = n.getPos().split(",")).length > 0 && (place = FormatUtil.getAixmGpsFromString(coords[0], coords[1])) != null) {
            this.lat = place.getLat().getValue();
            this.lon = place.getLon().getValue();
        }
    }

    public Navaid clone() {
        Navaid n = new Navaid();
        n.setId(this.id);
        n.setAlt(this.alt);
        n.setCountry(this.country);
        n.setFreq(this.freq);
        n.setIdent(this.ident);
        n.setLat(this.lat);
        n.setLon(this.lon);
        n.setName(this.name);
        n.setType(this.type);
        n.setRegion(this.region);
        n.setMagvar(this.magvar);
        n.setRemark(this.remark);
        return n;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="REMARK", length=512)
    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = StringUtil.shortenString(remark, 512);
    }

    @Column(name="IDENT", length=16)
    public String getIdent() {
        return this.ident;
    }

    public void setIdent(String ident) {
        this.ident = StringUtil.shortenString(ident, 16);
    }

    @Column(name="NAME", length=64)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtil.shortenString(name, 64);
    }

    @Column(name="TYPE", length=7)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    @Column(name="LAT", nullable=false, precision=18, scale=15)
    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    @Override
    @Column(name="LON", nullable=false, precision=18, scale=15)
    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    @Column(name="ALT")
    public Integer getAlt() {
        return this.alt;
    }

    public void setAlt(Integer alt) {
        this.alt = alt;
    }

    @Column(name="COUNTRY", length=2)
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = StringUtil.shortenString(country, 2);
    }

    @Transient
    public GpsPlace getGpsPlace() {
        GpsPlace place = new GpsPlace(new GpsCoord(this.getLat()), new GpsCoord(this.getLon()), this.getIdent(), this.getAlt() != null ? Double.valueOf(this.getAlt().intValue()) : null);
        place.setType(this.type);
        if (this.freq != null) {
            place.setDataInt("freq", this.freq);
        }
        if (this.magvar != null) {
            place.setDataDouble("magvar", this.magvar);
        }
        if (this.remark != null) {
            place.setDataString("remark", this.remark);
        }
        return place;
    }

    @Column(name="FREQ")
    public Integer getFreq() {
        return this.freq;
    }

    public void setFreq(Integer freq) {
        this.freq = freq;
    }

    @Transient
    public void setFreq(Double fr, String type) {
        this.freq = fr == null ? null : ("NDB".equals(type) ? Integer.valueOf((int)Math.round(fr * 10.0)) : Integer.valueOf((int)Math.round(fr * 1000.0)));
    }

    @Column(name="MAGVAR", precision=5, scale=2)
    public Double getMagvar() {
        return this.magvar;
    }

    public void setMagvar(Double magvar) {
        this.magvar = magvar;
    }

    @Transient
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    @Transient
    public boolean isNdb() {
        return "NDB".equals(this.type);
    }

    @Transient
    public boolean isDme() {
        return "DME".equals(this.type);
    }

    @Transient
    public boolean isVor() {
        return "VOR".equals(this.type) || "VOR-DME".equals(this.type) || "VORTAC".equals(this.type);
    }

    @Transient
    public boolean isTacan() {
        return "TACAN".equals(this.type) || "VORTAC".equals(this.type);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Navaid [id=");
        builder.append(this.id);
        builder.append(", remark=");
        builder.append(this.remark);
        builder.append(", ident=");
        builder.append(this.ident);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", type=");
        builder.append(this.type);
        builder.append(", lat=");
        builder.append(this.lat);
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append(", alt=");
        builder.append(this.alt);
        builder.append(", freq=");
        builder.append(this.freq);
        builder.append(", country=");
        builder.append(this.country);
        builder.append(", region=");
        builder.append(this.region);
        builder.append(", magvar=");
        builder.append(this.magvar);
        builder.append("]");
        return builder.toString();
    }
}

