/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.LatLonObject;
import main.java.guru.vfrflight.core.sql.entity.Runway;
import main.java.guru.vfrflight.core.sql.entity.xml.IlsXml;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.StringUtil;

@Entity
@Table(name="ILS")
public class Ils
implements LatLonObject,
Serializable {
    private static final long serialVersionUID = 4399116311408649184L;
    public static final String SELECT_QUERY = "SELECT id, runway_id, lat, lon, alt, heading, frequency, magvar, width, name, ident, gs, dme, airport_code FROM ils ";
    public static final String CREATE_QUERY = "CREATE CACHED TABLE ils ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), runway_id INTEGER, lat DECIMAL(18,15), lon DECIMAL(18,15), alt INTEGER, heading DECIMAL(5,2), frequency DECIMAL(6,3), magvar DECIMAL(5,2), width DECIMAL(5,2), pitch DECIMAL(5,2), name VARCHAR(48), ident VARCHAR(5), gs BOOLEAN, dme BOOLEAN, airport_id INTEGER, PRIMARY KEY (id), FOREIGN KEY (runway_id) REFERENCES runways (id))";
    public static final String DROP_QUERY = "DROP TABLE ils ";
    private Integer id;
    private Integer alt;
    private Integer airportId;
    private Runway runway;
    private Double lon;
    private Double lat;
    private Double heading;
    private Double frequency;
    private Double magvar;
    private Double width;
    private Double pitch;
    private String name;
    private String ident;
    private Boolean gs;
    private Boolean dme;

    public Ils() {
    }

    public Ils(IlsXml i) {
        GpsPlace place;
        String[] coords;
        this.alt = i.getElev();
        if (i.getPos() != null && (coords = i.getPos().split(",")).length > 0 && (place = FormatUtil.getAixmGpsFromString(coords[0], coords[1])) != null) {
            this.lat = place.getLat().getValue();
            this.lon = place.getLon().getValue();
        }
        this.heading = i.getHeading();
        this.frequency = i.getFrequency();
        this.magvar = i.getMagvar();
        this.width = i.getWidth();
        this.pitch = i.getPitch();
        this.name = i.getName();
        this.ident = i.getIdent();
        this.gs = i.getGs();
        this.dme = i.getDme();
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="GS", nullable=true)
    public Boolean getGs() {
        return this.gs;
    }

    public void setGs(Boolean gs) {
        this.gs = gs;
    }

    @Transient
    public boolean isGs() {
        if (this.gs == null) {
            return false;
        }
        return this.gs;
    }

    @Column(name="DME", nullable=true)
    public Boolean getDme() {
        return this.dme;
    }

    public void setDme(Boolean dme) {
        this.dme = dme;
    }

    @Transient
    public boolean isDme() {
        if (this.dme == null) {
            return false;
        }
        return this.dme;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="RUNWAY_ID")
    public Runway getRunway() {
        return this.runway;
    }

    public void setRunway(Runway runway) {
        this.runway = runway;
    }

    @Override
    @Column(name="LON", nullable=false, precision=18, scale=15)
    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    @Override
    @Column(name="LAT", nullable=false, precision=18, scale=15)
    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    @Column(name="HEADING", precision=5, scale=2)
    public Double getHeading() {
        return this.heading;
    }

    @Transient
    public Double getMagHeading() {
        Double hdg = null;
        if (this.heading != null) {
            hdg = this.heading;
            if (this.magvar != null) {
                hdg = GpsUtil.normalizeCourse(hdg - this.magvar);
            }
        }
        return hdg;
    }

    public void setHeading(Double heading) {
        this.heading = heading;
    }

    @Column(name="FREQUENCY", precision=6, scale=3)
    public Double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Double frequency) {
        this.frequency = frequency;
    }

    @Column(name="MAGVAR", precision=5, scale=2)
    public Double getMagvar() {
        return this.magvar;
    }

    public void setMagvar(Double magvar) {
        this.magvar = magvar;
    }

    @Column(name="WIDTH", precision=5, scale=2)
    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    @Column(name="NAME", length=48)
    public String getName() {
        return this.name;
    }

    @Column(name="PITCH", precision=5, scale=2, nullable=true)
    public Double getPitch() {
        return this.pitch;
    }

    public void setPitch(Double pitch) {
        this.pitch = pitch;
    }

    public void setName(String name) {
        this.name = StringUtil.shortenString(name, 48);
    }

    @Column(name="IDENT", length=5)
    public String getIdent() {
        return this.ident;
    }

    public void setIdent(String ident) {
        this.ident = StringUtil.shortenString(ident, 5);
    }

    @Column(name="ALT")
    public Integer getAlt() {
        return this.alt;
    }

    public void setAlt(Integer alt) {
        this.alt = alt;
    }

    @Transient
    public GpsPlace getGpsPlace() {
        GpsPlace place = new GpsPlace(new GpsCoord(this.getLat()), new GpsCoord(this.getLon()), this.getIdent(), this.getAlt() != null ? Double.valueOf(this.getAlt().intValue()) : null);
        place.setName(this.getIdent());
        place.setDataInt("freq", (int)Math.round(this.getFrequency() * 1000.0));
        place.setDataDouble("heading", this.getHeading());
        place.setDataDouble("width", this.getWidth());
        place.setDataDouble("magvar", this.getMagvar());
        return place;
    }

    @Column(name="AIRPORT_ID")
    public Integer getAirportId() {
        return this.airportId;
    }

    public void setAirportId(Integer airportId) {
        this.airportId = airportId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Ils [id=");
        builder.append(this.id);
        builder.append(", alt=");
        builder.append(this.alt);
        if (this.runway != null) {
            builder.append(", runway=");
            builder.append(this.runway.getId());
        }
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append(", lat=");
        builder.append(this.lat);
        builder.append(", heading=");
        builder.append(this.heading);
        builder.append(", frequency=");
        builder.append(this.frequency);
        builder.append(", magvar=");
        builder.append(this.magvar);
        builder.append(", width=");
        builder.append(this.width);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", ident=");
        builder.append(this.ident);
        builder.append(", gs=");
        builder.append(this.gs);
        builder.append(", dme=");
        builder.append(this.dme);
        builder.append(", airportId=");
        builder.append(this.airportId);
        builder.append("]");
        return builder.toString();
    }
}

