/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;

@Entity
@Table(name="ELEVATIONS")
public class Elevation
implements Serializable {
    private static final long serialVersionUID = -1489852704577544196L;
    public static final String CREATE_QUERY = "CREATE CACHED TABLE elevations ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), elev SMALLINT, lat DECIMAL(18,15), lon DECIMAL(18,15), PRIMARY KEY (id))";
    public static final String SELECT_QUERY = "SELECT id, elev, lat, lon FROM elevations ";
    public static final String DROP_QUERY = "DROP TABLE elevations ";
    private Integer id;
    private Short elev;
    private Double lat;
    private Double lon;

    public Elevation() {
    }

    public Elevation(Double lat, Double lon, Short elev) {
        this.lat = lat;
        this.lon = lon;
        this.elev = elev;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="ELEV", nullable=true)
    public Short getElev() {
        return this.elev;
    }

    public void setElev(Short elev) {
        this.elev = elev;
    }

    @Column(name="LAT", nullable=false, precision=18, scale=15)
    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    @Column(name="LON", nullable=false, precision=18, scale=15)
    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    @Transient
    public GpsPlace getGpsPlace() {
        return new GpsPlace(new GpsCoord(this.lat), new GpsCoord(this.lon));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Elevation [id=");
        builder.append(this.id);
        builder.append(", elev=");
        builder.append(this.elev);
        builder.append(", lat=");
        builder.append(this.lat);
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append("]");
        return builder.toString();
    }

    public Elevation clone() {
        Elevation el = new Elevation();
        el.setElev(this.elev);
        el.setId(this.id);
        el.setLat(this.lat);
        el.setLon(this.lon);
        return el;
    }

    public boolean isInside(GpsArea area) {
        return this.getLat() <= area.getMaxLat() && this.getLat() >= area.getMinLat() && this.getLon() >= area.getMinLon() && this.getLon() <= area.getMaxLon();
    }
}

