/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.util.StringUtil;

@Entity
@Table(name="CITIES")
public class City
implements Serializable {
    private static final long serialVersionUID = 3883379320370256298L;
    public static final String CREATE_QUERY = "CREATE CACHED TABLE cities ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), name VARCHAR(64), alt_name VARCHAR(128), lat DECIMAL(18,15), lon DECIMAL(18,15), size SMALLINT, village BOOLEAN, PRIMARY KEY (id))";
    public static final String INDEX_QUERY = "CREATE INDEX city_size ON cities (size)";
    public static final String DROP_QUERY = "DROP TABLE cities";
    public static final String DROP_INDEX_QUERY = "DROP INDEX city_size";
    private Integer id;
    private String name;
    private String altName;
    private Double lat;
    private Double lon;
    private Short size;
    private Boolean village;

    public City() {
    }

    public City(UserPoint p) {
        this.name = p.getName();
        this.lat = p.getLat();
        this.lon = p.getLon();
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="NAME", nullable=false, length=64)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtil.shortenString(name, 64);
    }

    @Column(name="ALT_NAME", nullable=true, length=128)
    public String getAltName() {
        return this.altName;
    }

    public void setAltName(String altName) {
        this.altName = StringUtil.shortenString(altName, 128);
    }

    @Column(name="LAT", nullable=false, precision=18, scale=15)
    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    @Column(name="LON", nullable=false, precision=18, scale=15)
    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    @Column(name="SIZE", nullable=true)
    public Short getSize() {
        return this.size;
    }

    public void setSize(Short size) {
        this.size = size;
    }

    @Transient
    public GpsPlace getGpsPlace() {
        return new GpsPlace(new GpsCoord(this.getLat()), new GpsCoord(this.getLon()), this.getName());
    }

    public Boolean getVillage() {
        return this.village;
    }

    public void setVillage(Boolean village) {
        this.village = village;
    }

    @Transient
    public boolean isVillage() {
        return Boolean.TRUE.equals(this.village);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("City [id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", altName=");
        builder.append(this.altName);
        builder.append(", lat=");
        builder.append(this.lat);
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append(", size=");
        builder.append(this.size);
        builder.append(", village=");
        builder.append(this.village);
        builder.append("]");
        return builder.toString();
    }
}

