/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Apron;
import main.java.guru.vfrflight.core.sql.entity.xml.ApronVertexXml;
import main.java.guru.vfrflight.util.FormatUtil;

@Entity
@Table(name="APRON_VERTICES")
public class ApronVertex
implements Serializable {
    private static final long serialVersionUID = -298276837737046759L;
    public static final String CREATE_QUERY = "CREATE CACHED TABLE apron_vertices ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), apron_id INTEGER, lat DECIMAL(18,15), lon DECIMAL(18,15), PRIMARY KEY (id), FOREIGN KEY (apron_id) REFERENCES aprons (id))";
    public static final String DROP_QUERY = "DROP TABLE apron_vertices ";
    private Integer id;
    private Apron apron;
    private Double lat;
    private Double lon;

    public ApronVertex() {
    }

    public ApronVertex(ApronVertexXml a) {
        GpsPlace place;
        String[] coords;
        if (a.getPos() != null && (coords = a.getPos().split(",")).length > 0 && (place = FormatUtil.getAixmGpsFromString(coords[0], coords[1])) != null) {
            this.lat = place.getLat().getValue();
            this.lon = place.getLon().getValue();
        }
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="APRON_ID")
    public Apron getApron() {
        return this.apron;
    }

    public void setApron(Apron apron) {
        this.apron = apron;
    }

    @Column(name="LAT", nullable=true, precision=18, scale=15)
    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    @Column(name="LON", nullable=true, precision=18, scale=15)
    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ApronVertex [lat=");
        builder.append(this.lat);
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append("]");
        return builder.toString();
    }
}

