/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.ApronVertex;
import main.java.guru.vfrflight.core.sql.entity.xml.ApronXml;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="APRONS")
public class Apron
implements Serializable {
    private static final long serialVersionUID = 5560159018516591570L;
    public static final String CREATE_QUERY = "CREATE CACHED TABLE aprons ( id INTEGER, airport_id INTEGER, PRIMARY KEY (id), FOREIGN KEY (airport_id) REFERENCES airports (id))";
    public static final String DROP_QUERY = "DROP TABLE aprons ";
    public static final String ID_SEQ_CREATE_QUERY = "CREATE SEQUENCE aprons_id_seq START WITH 1 INCREMENT BY 1";
    public static final String ID_SEQ_DROP_QUERY = "DROP SEQUENCE aprons_id_seq";
    private Integer id;
    private Airport airport;
    private List<ApronVertex> vertices;

    public Apron() {
    }

    public Apron(ApronXml a) {
        if (a.getVertices() != null && a.getVertices().size() > 0) {
            this.setVertices(a.getVertices());
        }
    }

    @Id
    @GenericGenerator(name="generator", strategy="sequence-identity", parameters={@Parameter(name="sequence", value="runways_id_seq")})
    @GeneratedValue(generator="generator")
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="AIRPORT_ID")
    public Airport getAirport() {
        return this.airport;
    }

    public void setAirport(Airport airport) {
        this.airport = airport;
    }

    @OneToMany(fetch=FetchType.EAGER, mappedBy="apron")
    public List<ApronVertex> getVertices() {
        if (this.vertices == null) {
            this.vertices = new ArrayList<ApronVertex>();
        }
        return this.vertices;
    }

    public void setVertices(List<ApronVertex> vertices) {
        this.vertices = vertices;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Apron [vertices=");
        builder.append(this.vertices);
        builder.append("]");
        return builder.toString();
    }
}

