/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.core.sql.entity.xml.AirspaceAreaVertexXml;
import main.java.guru.vfrflight.gui.map.shape.MapShapeVertex;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

@Entity
@Table(name="AIRSPACE_AREA_VERTEX")
public class AirspaceAreaVertex
implements Serializable {
    private static final long serialVersionUID = -2544651517376415184L;
    public static final String CREATE_QUERY = "CREATE CACHED TABLE airspace_area_vertex ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), index INTEGER, airspace_area_id INTEGER, lat DECIMAL(18,15), lon DECIMAL(18,15), radius DECIMAL(18,15), clockwise BOOLEAN, PRIMARY KEY (id), FOREIGN KEY (airspace_area_id) REFERENCES airspace_area (id))";
    public static final String DROP_QUERY = "DROP TABLE airspace_area_vertex ";
    private Integer id;
    private Integer index;
    private AirspaceArea airspaceArea;
    private Double lat;
    private Double lon;
    private Boolean clockwise;
    private Double radius;

    public AirspaceAreaVertex() {
    }

    public AirspaceAreaVertex clone() {
        AirspaceAreaVertex v = new AirspaceAreaVertex();
        v.setAirspaceArea(this.airspaceArea);
        v.setLat(this.lat);
        v.setLon(this.lon);
        v.setClockwise(this.clockwise);
        v.setRadius(this.radius);
        v.setIndex(this.index);
        return v;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="INDEX", nullable=false)
    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public AirspaceAreaVertex(Double lat, Double lon, Double radius) {
        this.lat = lat;
        this.lon = lon;
        this.radius = radius;
    }

    public AirspaceAreaVertex(Double lat, Double lon, Double radius, Boolean clockwise) {
        this(lat, lon, radius);
        this.clockwise = clockwise;
    }

    public AirspaceAreaVertex(GpsPlace place) {
        this(place.getLat().getValue(), (Double)place.getLon().getValue());
    }

    public AirspaceAreaVertex(GeoPosition place) {
        this(place.getLatitude(), (Double)place.getLongitude());
    }

    public AirspaceAreaVertex(GpsPlace place, Double radius) {
        this(place.getLat().getValue(), place.getLon().getValue(), radius);
    }

    public AirspaceAreaVertex(Double lat, Double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public AirspaceAreaVertex(MapShapeVertex v) {
        this.lat = v.getLat();
        this.lon = v.getLon();
        this.clockwise = v.getClockwise();
        this.radius = v.getRadius();
    }

    public AirspaceAreaVertex(AirspaceAreaVertexXml a) {
        GpsPlace place;
        String[] coords;
        this.index = a.getIndex();
        this.clockwise = a.getClockwise();
        this.radius = a.getRadius();
        if (a.getPos() != null && (coords = a.getPos().split(",")).length > 0 && (place = FormatUtil.getAixmGpsFromString(coords[0], coords[1])) != null) {
            this.lat = place.getLat().getValue();
            this.lon = place.getLon().getValue();
        }
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="AIRSPACE_AREA_ID")
    public AirspaceArea getAirspaceArea() {
        return this.airspaceArea;
    }

    public void setAirspaceArea(AirspaceArea airspaceArea) {
        this.airspaceArea = airspaceArea;
    }

    @Column(name="LAT", nullable=false, precision=18, scale=15)
    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    @Column(name="LON", nullable=false, precision=18, scale=15)
    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    @Column(name="RADIUS", precision=18, scale=15)
    public Double getRadius() {
        return this.radius;
    }

    public void setRadius(Double radius) {
        this.radius = radius;
    }

    @Transient
    public GpsPlace getGpsPlace() {
        return new GpsPlace(new GpsCoord(this.lat), new GpsCoord(this.lon));
    }

    @Transient
    public boolean isVertex() {
        return this.radius == null;
    }

    @Transient
    public boolean isInside(GpsArea area) {
        if (area == null) {
            return false;
        }
        return this.lat <= area.getMaxLat() && this.lat >= area.getMinLat() && this.lon >= area.getMinLon() && this.lon <= area.getMaxLon();
    }

    @Column(name="CLOCKWISE")
    public Boolean getClockwise() {
        return this.clockwise;
    }

    public void setClockwise(Boolean clockwise) {
        this.clockwise = clockwise;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AirspaceAreaVertex [id=");
        builder.append(this.id);
        builder.append(", index=");
        builder.append(this.index);
        builder.append(", lat=");
        builder.append(this.lat);
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append(", clockwise=");
        builder.append(this.clockwise);
        builder.append(", radius=");
        builder.append(this.radius);
        builder.append("]");
        return builder.toString();
    }
}

