/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import main.java.guru.vfrflight.core.comparator.VertexIndexComparator;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsVertex;
import main.java.guru.vfrflight.core.sql.entity.AirspaceAreaVertex;
import main.java.guru.vfrflight.core.sql.entity.xml.AirspaceAreaXml;
import main.java.guru.vfrflight.core.sql.type.AirspaceType;
import main.java.guru.vfrflight.core.sql.type.AltitudeType;
import main.java.guru.vfrflight.util.AirspacesUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

@Entity
@Table(name="AIRSPACE_AREA")
public class AirspaceArea
implements Serializable {
    private static final long serialVersionUID = -1589050084315327816L;
    public static final String CREATE_QUERY = "CREATE CACHED TABLE airspace_area ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), name VARCHAR(128), remark VARCHAR(512), bottom_alt INTEGER, bottom_alt_type VARCHAR(9), top_alt INTEGER, top_alt_type VARCHAR(9), radius DECIMAL(18,15), circle_center_lat DECIMAL(18,15), circle_center_lon DECIMAL(18,15), type VARCHAR(13), PRIMARY KEY (id))";
    public static final String DROP_QUERY = "DROP TABLE airspace_area ";
    public static final Integer GND = 0;
    public static final Integer FL95 = 9500;
    private Integer id;
    private List<AirspaceAreaVertex> vertices;
    private String name;
    private String remark;
    private Integer bottomAltitude;
    private AltitudeType bottomAltitudeType;
    private Integer topAltitude;
    private AltitudeType topAltitudeType;
    private Double radius;
    private Double circleCenterLat;
    private Double circleCenterLon;
    private AirspaceType type;
    private GeoPosition center;
    private List<GeoPosition> origins;
    private GpsArea rectangleOver;

    public AirspaceArea() {
    }

    public AirspaceArea(String name) {
        this.name = name;
    }

    public AirspaceArea(AirspaceType type) {
        this.type = type;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public AirspaceArea(String name, AirspaceType type) {
        this.name = name;
        this.type = type;
    }

    public AirspaceArea(AirspaceAreaXml a) {
        GpsPlace place;
        String[] coords;
        this.name = a.getName();
        this.remark = a.getRemark();
        this.bottomAltitude = a.getBottomAlt();
        this.topAltitude = a.getTopAlt();
        this.bottomAltitudeType = a.getBottomAltType();
        this.topAltitudeType = a.getTopAltType();
        this.radius = a.getCircleRadius();
        this.type = a.getType();
        if (a.getCircleCenterPos() != null && (coords = a.getCircleCenterPos().split(",")).length > 0 && (place = FormatUtil.getAixmGpsFromString(coords[0], coords[1])) != null) {
            this.circleCenterLat = place.getLat().getValue();
            this.circleCenterLon = place.getLon().getValue();
        }
        if (a.getVertices().size() > 0) {
            this.vertices = a.getVertices();
        } else if (a.getVerticesList() != null) {
            this.vertices = AirspacesUtil.getAirspaceAreaVerticesFromString(a.getVerticesList());
        }
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="airspaceArea")
    public List<AirspaceAreaVertex> getVertices() {
        if (this.vertices == null) {
            this.vertices = new ArrayList<AirspaceAreaVertex>();
        }
        return this.vertices;
    }

    public void setVertices(List<AirspaceAreaVertex> vertices) {
        this.vertices = vertices;
    }

    @Transient
    public List<GpsVertex> getGpsVertices() {
        LinkedList<GpsVertex> result = new LinkedList<GpsVertex>();
        for (AirspaceAreaVertex v : this.getVertices()) {
            result.add(v.getGpsPlace());
        }
        return result;
    }

    @Column(name="NAME", length=128)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtil.shortenString(name, 128);
    }

    @Column(name="BOTTOM_ALT")
    public Integer getBottomAltitude() {
        return this.bottomAltitude;
    }

    public void setBottomAltitude(Integer bottomAltitude) {
        this.bottomAltitude = bottomAltitude;
    }

    @Column(name="TOP_ALT")
    public Integer getTopAltitude() {
        return this.topAltitude;
    }

    public void setTopAltitude(Integer topAltitude) {
        this.topAltitude = topAltitude;
    }

    @Column(name="RADIUS", precision=18, scale=15)
    public Double getRadius() {
        return this.radius;
    }

    public void setRadius(Double radius) {
        this.radius = radius;
    }

    @Column(name="TYPE")
    @Enumerated(value=EnumType.STRING)
    public AirspaceType getType() {
        return this.type;
    }

    public void setType(AirspaceType type) {
        this.type = type;
    }

    @Transient
    public boolean isPoly() {
        return this.getVertices().size() > 1;
    }

    @Transient
    public boolean isCircle() {
        return this.radius != null && (this.circleCenterLat != null || this.circleCenterLon != null);
    }

    @Transient
    public boolean isInside(GpsArea area) {
        if (this.getRectangleOver() == null) {
            return false;
        }
        return this.getRectangleOver().isInside(area) || area.isInside(this.getRectangleOver());
    }

    @Transient
    public GpsArea getRectangleOver() {
        if (this.rectangleOver == null && this.isPoly() && this.getVertices().size() > 0) {
            this.rectangleOver = GpsUtil.getRectangleOverVertices(this.getGpsVertices());
        } else if (this.rectangleOver == null && this.isCircle()) {
            this.rectangleOver = GpsUtil.getCircleArea(this.getCircleCenter(), this.getRadius());
        }
        return this.rectangleOver;
    }

    public void setRectangleOver(GpsArea rectangleOver) {
        this.rectangleOver = rectangleOver;
    }

    @Column(name="CIRCLE_CENTER_LAT", precision=18, scale=15)
    public Double getCircleCenterLat() {
        return this.circleCenterLat;
    }

    public void setCircleCenterLat(Double circleCenterLat) {
        this.circleCenterLat = circleCenterLat;
    }

    @Column(name="CIRCLE_CENTER_LON", precision=18, scale=15)
    public Double getCircleCenterLon() {
        return this.circleCenterLon;
    }

    public void setCircleCenterLon(Double circleCenterLon) {
        this.circleCenterLon = circleCenterLon;
    }

    @Transient
    public GpsPlace getCircleCenter() {
        if (this.circleCenterLat != null && this.circleCenterLon != null) {
            return new GpsPlace(new GpsCoord(this.circleCenterLat), new GpsCoord(this.circleCenterLon));
        }
        return null;
    }

    @Transient
    public GeoPosition getCenter() {
        if (this.center == null) {
            if (this.getVertices().size() == 0) {
                return this.isCircle() ? new GeoPosition(this.circleCenterLat, this.circleCenterLon) : null;
            }
            double lat = 0.0;
            double lon = 0.0;
            int i = 0;
            for (AirspaceAreaVertex v : this.getVertices()) {
                lat += v.getLat().doubleValue();
                lon += v.getLon().doubleValue();
                ++i;
            }
            this.center = new GeoPosition(lat / (double)i, lon / (double)i);
        }
        return this.center;
    }

    public void setCenter(GeoPosition center) {
        this.center = center;
    }

    @Column(name="BOTTOM_ALT_TYPE")
    @Enumerated(value=EnumType.STRING)
    public AltitudeType getBottomAltitudeType() {
        return this.bottomAltitudeType;
    }

    public void setBottomAltitudeType(AltitudeType bottomAltitudeType) {
        this.bottomAltitudeType = bottomAltitudeType;
    }

    @Column(name="TOP_ALT_TYPE")
    @Enumerated(value=EnumType.STRING)
    public AltitudeType getTopAltitudeType() {
        return this.topAltitudeType;
    }

    public void setTopAltitudeType(AltitudeType topAltitudeType) {
        this.topAltitudeType = topAltitudeType;
    }

    @Column(name="REMARK", length=512)
    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = StringUtil.shortenString(remark, 512);
    }

    @Transient
    public List<GeoPosition> getOrigins() {
        if (this.origins == null) {
            this.origins = new ArrayList<GeoPosition>();
        }
        return this.origins;
    }

    public void setOrigins(List<GeoPosition> origins) {
        this.origins = origins;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AirspaceArea [id=");
        builder.append(this.id);
        builder.append(", vertices=");
        builder.append(this.vertices);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", bottomAltitude=");
        builder.append(this.bottomAltitude);
        builder.append(", bottomAltitudeType=");
        builder.append((Object)this.bottomAltitudeType);
        builder.append(", topAltitude=");
        builder.append(this.topAltitude);
        builder.append(", topAltitudeType=");
        builder.append((Object)this.topAltitudeType);
        builder.append(", radius=");
        builder.append(this.radius);
        builder.append(", circleCenterLat=");
        builder.append(this.circleCenterLat);
        builder.append(", circleCenterLon=");
        builder.append(this.circleCenterLon);
        builder.append(", type=");
        builder.append((Object)this.type);
        builder.append(", center=");
        builder.append(this.center);
        builder.append(", origins=");
        builder.append(this.origins);
        builder.append(", rectangleOver=");
        builder.append(this.rectangleOver);
        builder.append("]");
        return builder.toString();
    }

    public String toFormattedString() {
        StringBuilder sb = new StringBuilder();
        if (this.getId() != null) {
            sb.append("[");
            sb.append(this.getId());
            sb.append("]");
        }
        if (this.getName() != null) {
            sb.append(" ");
            sb.append(this.getName());
        }
        return sb.toString();
    }

    public void eagerLoad() {
        Collections.sort(this.getVertices(), new VertexIndexComparator());
    }

    @Transient
    public boolean isClockwise() {
        GpsPlace center = this.getCenter().gpsPlace();
        int clockwiseNum = 0;
        for (int i = 1; i < this.getVertices().size() + 1; ++i) {
            double crs;
            GpsPlace pv = this.getVertices().get(i - 1).getGpsPlace();
            GpsPlace v = i < this.getVertices().size() ? this.getVertices().get(i).getGpsPlace() : this.getVertices().get(0).getGpsPlace();
            double prevCrs = GpsUtil.getCourse(center, pv);
            if (!GpsUtil.isClockwise(prevCrs, crs = GpsUtil.getCourse(center, v))) continue;
            ++clockwiseNum;
        }
        return clockwiseNum >= (int)Math.ceil((double)this.getVertices().size() / 2.0);
    }

    @Transient
    public String getUniqueHash() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append(this.name);
        }
        if (this.type != null) {
            sb.append((Object)this.type);
        }
        if (this.bottomAltitude != null) {
            sb.append(this.bottomAltitude);
        }
        if (this.bottomAltitudeType != null) {
            sb.append((Object)this.bottomAltitudeType);
        }
        if (this.topAltitude != null) {
            sb.append(this.topAltitude);
        }
        if (this.topAltitudeType != null) {
            sb.append((Object)this.topAltitudeType);
        }
        if (this.isPoly()) {
            sb.append(this.getVertices().size());
        } else if (this.isCircle()) {
            sb.append(this.getRadius());
            sb.append(this.getCircleCenterLat());
            sb.append(this.getCircleCenterLon());
        }
        return sb.toString();
    }
}

