/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.xml.AirportStartXml;
import main.java.guru.vfrflight.core.sql.type.RunwayDesignator;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.StringUtil;

@Entity
@Table(name="AIRPORT_START")
public class AirportStart
implements Serializable,
Comparable<AirportStart> {
    private static final long serialVersionUID = 1443939382354124689L;
    public static final String CREATE_QUERY = "CREATE CACHED TABLE airport_start ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), airport_id INTEGER, lat DECIMAL(18,15), lon DECIMAL(18,15), number INTEGER, elev INTEGER, designator VARCHAR(10), name VARCHAR(48), heading DECIMAL(5,2), PRIMARY KEY (id), FOREIGN KEY (airport_id) REFERENCES airports (id))";
    public static final String SELECT_QUERY = "SELECT id, airport_id, lat, lon, number, elev, designator, heading, name FROM airport_start ";
    public static final String DROP_QUERY = "DROP TABLE airport_start ";
    private Integer id;
    private Airport airport;
    private Double lat;
    private Double lon;
    private Integer number;
    private Integer elev;
    private Double heading;
    private RunwayDesignator designator;
    private String name;

    public AirportStart() {
    }

    public AirportStart(AirportStartXml a) {
        GpsPlace place;
        String[] coords;
        if (a.getPos() != null && (coords = a.getPos().split(",")).length > 0 && (place = FormatUtil.getAixmGpsFromString(coords[0], coords[1])) != null) {
            this.lat = place.getLat().getValue();
            this.lon = place.getLon().getValue();
        }
        this.elev = a.getElev();
        this.number = a.getNumber();
        this.heading = a.getDirection();
        this.designator = a.getDesignator();
        this.name = a.getName();
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="AIRPORT_ID")
    public Airport getAirport() {
        return this.airport;
    }

    public void setAirport(Airport airport) {
        this.airport = airport;
    }

    @Column(name="LAT", nullable=false, precision=18, scale=15)
    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    @Column(name="LON", nullable=false, precision=18, scale=15)
    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    @Column(name="NUMBER")
    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    @Column(name="ELEV")
    public Integer getElev() {
        return this.elev;
    }

    public void setElev(Integer elev) {
        this.elev = elev;
    }

    @Column(name="HEADING", nullable=false, precision=5, scale=2)
    public Double getHeading() {
        return this.heading;
    }

    public void setHeading(Double heading) {
        this.heading = heading;
    }

    @Column(name="DESIGNATOR")
    @Enumerated(value=EnumType.STRING)
    public RunwayDesignator getDesignator() {
        return this.designator;
    }

    public void setDesignator(RunwayDesignator designator) {
        this.designator = designator;
    }

    @Column(name="NAME", length=48)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtil.shortenString(name, 48);
    }

    @Transient
    public GpsPlace getGpsPlace() {
        return new GpsPlace(new GpsCoord(this.getLat()), new GpsCoord(this.getLon()));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AirportStarts [id=");
        builder.append(this.id);
        builder.append(", airport.id=");
        if (this.airport != null) {
            builder.append(this.airport.getId());
        }
        builder.append(", lat=");
        builder.append(this.lat);
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append(", number=");
        builder.append(this.number);
        builder.append(", elev=");
        builder.append(this.elev);
        builder.append(", heading=");
        builder.append(this.heading);
        builder.append(", designator=");
        builder.append((Object)this.designator);
        builder.append(", name=");
        builder.append(this.name);
        builder.append("]");
        return builder.toString();
    }

    @Transient
    public String getDeparturePosition() {
        if (this.name != null) {
            String[] txt = this.name.split(" -- ");
            return txt[0];
        }
        return null;
    }

    @Override
    public int compareTo(AirportStart o) {
        return StringUtil.nullToEmpty(this.getName()).compareTo(StringUtil.nullToEmpty(o.getName()));
    }
}

