/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.xml.AirportFreqXml;
import main.java.guru.vfrflight.core.sql.type.AirportFreqType;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.StringUtil;

@Entity
@Table(name="AIRPORT_FREQ")
public class AirportFreq
implements Serializable,
Comparable<AirportFreq> {
    private static final long serialVersionUID = -1183132441579043933L;
    public static final String CREATE_QUERY = "CREATE CACHED TABLE airport_freq ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), airport_id INTEGER, name VARCHAR(100), frequency DECIMAL(6,3), type VARCHAR(30), PRIMARY KEY (id), FOREIGN KEY (airport_id) REFERENCES airports (id))";
    public static final String DROP_QUERY = "DROP TABLE airport_freq";
    public static final String SELECT_QUERY = "SELECT id, airport_id, name, frequency, type FROM airport_freq ";
    private Integer id;
    private Airport airport;
    private String name;
    private Double frequency;
    private AirportFreqType type;

    public AirportFreq() {
    }

    public AirportFreq(AirportFreqXml a) {
        this.name = a.getName();
        this.frequency = a.getFrequency();
        this.type = a.getType();
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="AIRPORT_ID")
    public Airport getAirport() {
        return this.airport;
    }

    public void setAirport(Airport airport) {
        this.airport = airport;
    }

    @Column(name="NAME", length=100)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtil.shortenString(name, 100);
    }

    @Column(name="FREQUENCY", precision=6, scale=3)
    public Double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Double frequency) {
        if (NumberUtil.isDoubleValid(frequency, 6, 3)) {
            this.frequency = frequency;
        }
    }

    @Column(name="TYPE")
    @Enumerated(value=EnumType.STRING)
    public AirportFreqType getType() {
        return this.type;
    }

    public void setType(AirportFreqType type) {
        this.type = type;
    }

    @Override
    public int compareTo(AirportFreq o) {
        if (this.type == null && o.getType() == null) {
            return 0;
        }
        if (this.type == null && o.getType() != null) {
            return 1;
        }
        if (this.type != null && o.getType() == null) {
            return -1;
        }
        return this.type.toString().compareTo(o.getType().toString());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AirportFreq [id=");
        builder.append(this.id);
        builder.append(", airport.id=");
        if (this.airport != null) {
            builder.append(this.airport.getId());
        }
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", frequency=");
        builder.append(this.frequency);
        builder.append(", type=");
        builder.append((Object)this.type);
        builder.append("]");
        return builder.toString();
    }
}

