/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.LatLonObject;
import main.java.guru.vfrflight.core.sql.entity.AirportFreq;
import main.java.guru.vfrflight.core.sql.entity.AirportStart;
import main.java.guru.vfrflight.core.sql.entity.Apron;
import main.java.guru.vfrflight.core.sql.entity.Ils;
import main.java.guru.vfrflight.core.sql.entity.Runway;
import main.java.guru.vfrflight.core.sql.entity.TaxiName;
import main.java.guru.vfrflight.core.sql.entity.Taxiway;
import main.java.guru.vfrflight.core.sql.entity.xml.AirportXml;
import main.java.guru.vfrflight.core.sql.type.AirportType;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.StringUtil;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="AIRPORTS")
public class Airport
implements Serializable,
LatLonObject {
    private static final long serialVersionUID = 3789676851931691312L;
    public static final String CREATE_QUERY = "CREATE CACHED TABLE airports ( id INTEGER, ident VARCHAR(16), name VARCHAR(128), type VARCHAR(14), lat DECIMAL(18,15), lon DECIMAL(18,15), main_rwy INTEGER, main_length INTEGER, elev INTEGER, magvar DECIMAL(5,2), ils BOOLEAN, mountainous BOOLEAN, skewedIls BOOLEAN, vor BOOLEAN, ndb BOOLEAN, heli BOOLEAN, hardened BOOLEAN, PRIMARY KEY (id))";
    public static final String DROP_QUERY = "DROP TABLE airports";
    public static final String ID_SEQ_CREATE_QUERY = "CREATE SEQUENCE airports_id_seq START WITH 1 INCREMENT BY 1";
    public static final String ID_SEQ_DROP_QUERY = "DROP SEQUENCE airports_id_seq";
    private Integer id;
    private String ident;
    private String name;
    private Double lat;
    private Double lon;
    private Integer mainRwy;
    private Integer mainLength;
    private Integer elev;
    private Double magvar;
    private List<Runway> runways;
    private List<Taxiway> taxiways;
    private List<TaxiName> taxiNames;
    private List<Apron> aprons;
    private List<AirportStart> starts;
    private List<AirportFreq> frequencies;
    private Boolean ils;
    private Boolean mountainous;
    private Boolean heli;
    private Boolean vor;
    private Boolean ndb;
    private Boolean skewedIls;
    private Boolean hardened;
    private AirportType type;

    public Airport() {
    }

    public Airport(AirportXml a) {
        GpsPlace place;
        String[] coords;
        this.ident = a.getIdent();
        this.name = a.getName();
        if (a.getPos() != null && (coords = a.getPos().split(",")).length > 0 && (place = FormatUtil.getAixmGpsFromString(coords[0], coords[1])) != null) {
            this.lat = place.getLat().getValue();
            this.lon = place.getLon().getValue();
        }
        this.mainRwy = a.getMainRwy();
        this.mainLength = a.getMainLength();
        this.elev = a.getElev();
        this.magvar = a.getMagvar();
        this.ils = a.getIls();
        this.mountainous = a.getMountainous();
        this.vor = a.getVor();
        this.ndb = a.getNdb();
        this.type = a.getType();
        this.heli = a.getHeli();
        this.hardened = a.getHardened();
        if (a.getFrequencies() != null && a.getFrequencies().size() > 0) {
            this.setFrequencies(a.getFrequencies());
        }
        if (a.getStarts() != null && a.getStarts().size() > 0) {
            this.setStarts(a.getStarts());
        }
        if (a.getTaxiways() != null && a.getTaxiways().size() > 0) {
            this.setTaxiways(a.getTaxiways());
        }
        if (a.getTaxiNames() != null && a.getTaxiNames().size() > 0) {
            this.setTaxiNames(a.getTaxiNames());
        }
        if (a.getAprons() != null && a.getAprons().size() > 0) {
            this.setAprons(a.getAprons());
        }
        if (a.getRunways() != null && a.getRunways().size() > 0) {
            this.setRunways(a.getRunways());
        }
    }

    @Id
    @GenericGenerator(name="generator", strategy="sequence-identity", parameters={@Parameter(name="sequence", value="airports_id_seq")})
    @GeneratedValue(generator="generator")
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="IDENT", length=16)
    public String getIdent() {
        return this.ident;
    }

    public void setIdent(String ident) {
        this.ident = StringUtil.shortenString(ident, 16);
    }

    @Column(name="NAME", length=128)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtil.shortenString(name, 128);
    }

    @Transient
    public String getIdentOrName() {
        if (this.ident != null) {
            return this.ident;
        }
        return this.name;
    }

    @Transient
    public String getIdentAndName() {
        if (!StringUtil.isEmpty(this.getIdent()) && !StringUtil.isEmpty(this.getName())) {
            return this.getIdent() + " (" + this.getName() + ")";
        }
        return this.getIdentOrName();
    }

    @Override
    @Column(name="LAT", nullable=false, precision=18, scale=15)
    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    @Override
    @Column(name="LON", nullable=false, precision=18, scale=15)
    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    @Column(name="ELEV")
    public Integer getElev() {
        return this.elev;
    }

    public void setElev(Integer elev) {
        this.elev = elev;
    }

    @Transient
    public GpsPlace getGpsPlace() {
        GpsPlace place = new GpsPlace(new GpsCoord(this.getLat()), new GpsCoord(this.getLon()), this.getIdentOrName(), this.getElev() != null ? Double.valueOf(this.getElev().intValue()) : null);
        if (this.mainRwy != null) {
            place.setDataInt("mainRwy", this.mainRwy);
        }
        if (this.mainLength != null) {
            place.setDataInt("mainLength", this.mainLength);
        }
        if (this.elev != null) {
            place.setDataInt("elev", this.elev);
        }
        return place;
    }

    @Column(name="MAIN_RWY")
    public Integer getMainRwy() {
        return this.mainRwy;
    }

    public void setMainRwy(Integer mainRwy) {
        this.mainRwy = mainRwy;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="airport")
    public List<Runway> getRunways() {
        if (this.runways == null) {
            this.runways = new ArrayList<Runway>();
        }
        return this.runways;
    }

    public void setRunways(List<Runway> runways) {
        this.runways = runways;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="airport")
    public List<Apron> getAprons() {
        if (this.aprons == null) {
            this.aprons = new ArrayList<Apron>();
        }
        return this.aprons;
    }

    public void setAprons(List<Apron> aprons) {
        this.aprons = aprons;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="airport")
    public List<Taxiway> getTaxiways() {
        if (this.taxiways == null) {
            this.taxiways = new ArrayList<Taxiway>();
        }
        return this.taxiways;
    }

    public void setTaxiways(List<Taxiway> taxiways) {
        this.taxiways = taxiways;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="airport")
    public List<TaxiName> getTaxiNames() {
        if (this.taxiNames == null) {
            this.taxiNames = new ArrayList<TaxiName>();
        }
        return this.taxiNames;
    }

    public void setTaxiNames(List<TaxiName> taxiNames) {
        this.taxiNames = taxiNames;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="airport")
    public List<AirportStart> getStarts() {
        if (this.starts == null) {
            this.starts = new ArrayList<AirportStart>();
        }
        return this.starts;
    }

    public void setStarts(List<AirportStart> starts) {
        this.starts = starts;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="airport")
    public List<AirportFreq> getFrequencies() {
        if (this.frequencies == null) {
            this.frequencies = new ArrayList<AirportFreq>();
        }
        return this.frequencies;
    }

    public void setFrequencies(List<AirportFreq> frequencies) {
        this.frequencies = frequencies;
    }

    @Transient
    public List<Ils> getAllIls() {
        ArrayList<Ils> ils = new ArrayList<Ils>();
        for (Runway r : this.getRunways()) {
            ils.addAll(r.getIls());
        }
        return ils;
    }

    @Column(name="MAGVAR", precision=5, scale=2)
    public Double getMagvar() {
        return this.magvar;
    }

    public void setMagvar(Double magvar) {
        this.magvar = magvar;
    }

    @Column(name="MAIN_LENGTH")
    public Integer getMainLength() {
        return this.mainLength;
    }

    public void setMainLength(Integer mainLength) {
        this.mainLength = mainLength;
    }

    @Column(name="ILS", nullable=true)
    public Boolean getIls() {
        return this.ils;
    }

    public void setIls(Boolean ils) {
        this.ils = ils;
    }

    @Column(name="HARDENED", nullable=true)
    public Boolean getHardened() {
        return this.hardened;
    }

    public void setHardened(Boolean hardened) {
        this.hardened = hardened;
    }

    @Transient
    public boolean isHardened() {
        return Boolean.TRUE.equals(this.getHardened());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Airport [id=");
        builder.append(this.id);
        builder.append(", ident=");
        builder.append(this.ident);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", lat=");
        builder.append(this.lat);
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append(", mainRwy=");
        builder.append(this.mainRwy);
        builder.append(", mainLength=");
        builder.append(this.mainLength);
        builder.append(", elev=");
        builder.append(this.elev);
        builder.append(", magvar=");
        builder.append(this.magvar);
        builder.append(", ils=");
        builder.append(this.ils);
        builder.append(", mountainous=");
        builder.append(this.mountainous);
        builder.append(", vor=");
        builder.append(this.vor);
        builder.append(", ndb=");
        builder.append(this.ndb);
        builder.append(", heli=");
        builder.append(this.heli);
        builder.append(", hardened=");
        builder.append(this.hardened);
        builder.append("]");
        return builder.toString();
    }

    public void eagerLoad() {
        this.getStarts().size();
        for (Runway r : this.getRunways()) {
            r.getIls().size();
        }
        this.getFrequencies().size();
        this.getTaxiways().size();
        this.getTaxiNames().size();
        this.getAprons().size();
    }

    @Transient
    public boolean isIls() {
        return Boolean.TRUE.equals(this.getIls());
    }

    public Boolean getSkewedIls() {
        return this.skewedIls;
    }

    public void setSkewedIls(Boolean skewedIls) {
        this.skewedIls = skewedIls;
    }

    @Transient
    public boolean isSkewedIls() {
        return Boolean.TRUE.equals(this.getSkewedIls());
    }

    public Boolean getMountainous() {
        return this.mountainous;
    }

    public void setMountainous(Boolean mountainous) {
        this.mountainous = mountainous;
    }

    @Transient
    public boolean isMountainous() {
        return Boolean.TRUE.equals(this.getMountainous());
    }

    public Boolean getVor() {
        return this.vor;
    }

    public void setVor(Boolean vor) {
        this.vor = vor;
    }

    @Transient
    public boolean isVor() {
        return Boolean.TRUE.equals(this.getVor());
    }

    public Boolean getNdb() {
        return this.ndb;
    }

    public void setNdb(Boolean ndb) {
        this.ndb = ndb;
    }

    public Boolean getHeli() {
        return this.heli;
    }

    public void setHeli(Boolean heli) {
        this.heli = heli;
    }

    @Transient
    public boolean isNdb() {
        return Boolean.TRUE.equals(this.getNdb());
    }

    @Column(name="TYPE")
    @Enumerated(value=EnumType.STRING)
    public AirportType getType() {
        return this.type;
    }

    public void setType(AirportType type) {
        this.type = type;
    }

    @Transient
    public boolean isHeli() {
        return Boolean.TRUE.equals(this.getHeli());
    }
}

