/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsVertex;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class TerrainMesh
implements Serializable {
    private static final long serialVersionUID = -5732281847424888084L;
    private GeoPosition topLeftCorner;
    private GeoPosition bottomRightCorner;
    private short value;
    private GpsArea rectangleOver;
    private Color color;

    public TerrainMesh(GeoPosition topLeftCorner, GeoPosition bottomRightCorner, short value) {
        this.topLeftCorner = topLeftCorner;
        this.bottomRightCorner = bottomRightCorner;
        this.value = value;
    }

    public TerrainMesh() {
    }

    public short getValue() {
        return this.value;
    }

    public void setValue(short value) {
        this.value = value;
    }

    public boolean isInside(GpsArea area) {
        if (this.topLeftCorner != null && area.contains(this.topLeftCorner)) {
            return true;
        }
        return this.bottomRightCorner != null && area.contains(this.bottomRightCorner);
    }

    public void calculateRectangleOver() {
        ArrayList<GpsVertex> vertices = new ArrayList<GpsVertex>();
        vertices.add(this.topLeftCorner.gpsPlace());
        vertices.add(this.bottomRightCorner.gpsPlace());
        this.rectangleOver = GpsUtil.getRectangleOverVertices(vertices);
    }

    public GpsArea getRectangleOver() {
        if (this.rectangleOver == null) {
            this.calculateRectangleOver();
        }
        return this.rectangleOver;
    }

    public void setRectangleOver(GpsArea rectangleOver) {
        this.rectangleOver = rectangleOver;
    }

    public GeoPosition getTopLeftCorner() {
        return this.topLeftCorner;
    }

    public void setTopLeftCorner(GeoPosition topLeftCorner) {
        this.topLeftCorner = topLeftCorner;
    }

    public GeoPosition getBottomRightCorner() {
        return this.bottomRightCorner;
    }

    public void setBottomRightCorner(GeoPosition bottomRightCorner) {
        this.bottomRightCorner = bottomRightCorner;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public TerrainMesh clone() {
        TerrainMesh mesh = new TerrainMesh();
        mesh.setBottomRightCorner(this.bottomRightCorner);
        mesh.setColor(this.color);
        mesh.setRectangleOver(this.rectangleOver);
        mesh.setTopLeftCorner(this.topLeftCorner);
        mesh.setValue(this.value);
        return mesh;
    }
}

