/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.sql;

import java.io.Serializable;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class ImageMesh
implements Serializable {
    private static final long serialVersionUID = -806051306047912723L;
    private GeoPosition topLeftCorner;
    private GeoPosition bottomRightCorner;
    private float a;
    private float r;
    private float g;
    private float b;

    public ImageMesh(GeoPosition topLeftCorner, GeoPosition bottomRightCorner, float a, float r, float g, float b) {
        this.topLeftCorner = topLeftCorner;
        this.bottomRightCorner = bottomRightCorner;
        this.a = a;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public boolean isInside(GpsArea area) {
        if (this.topLeftCorner != null && area.contains(this.topLeftCorner)) {
            return true;
        }
        return this.bottomRightCorner != null && area.contains(this.bottomRightCorner);
    }

    public GeoPosition getTopLeftCorner() {
        return this.topLeftCorner;
    }

    public void setTopLeftCorner(GeoPosition topLeftCorner) {
        this.topLeftCorner = topLeftCorner;
    }

    public GeoPosition getBottomRightCorner() {
        return this.bottomRightCorner;
    }

    public void setBottomRightCorner(GeoPosition bottomRightCorner) {
        this.bottomRightCorner = bottomRightCorner;
    }

    public float getR() {
        return this.r;
    }

    public void setR(float r) {
        this.r = r;
    }

    public float getG() {
        return this.g;
    }

    public void setG(float g) {
        this.g = g;
    }

    public float getB() {
        return this.b;
    }

    public void setB(float b) {
        this.b = b;
    }

    public float getA() {
        return this.a;
    }

    public void setA(float a) {
        this.a = a;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.a);
        result = 31 * result + Float.floatToIntBits(this.b);
        result = 31 * result + (this.bottomRightCorner == null ? 0 : this.bottomRightCorner.hashCode());
        result = 31 * result + Float.floatToIntBits(this.g);
        result = 31 * result + Float.floatToIntBits(this.r);
        result = 31 * result + (this.topLeftCorner == null ? 0 : this.topLeftCorner.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageMesh other = (ImageMesh)obj;
        if (Float.floatToIntBits(this.a) != Float.floatToIntBits(other.a)) {
            return false;
        }
        if (Float.floatToIntBits(this.b) != Float.floatToIntBits(other.b)) {
            return false;
        }
        if (this.bottomRightCorner == null ? other.bottomRightCorner != null : !this.bottomRightCorner.equals(other.bottomRightCorner)) {
            return false;
        }
        if (Float.floatToIntBits(this.g) != Float.floatToIntBits(other.g)) {
            return false;
        }
        if (Float.floatToIntBits(this.r) != Float.floatToIntBits(other.r)) {
            return false;
        }
        return !(this.topLeftCorner == null ? other.topLeftCorner != null : !this.topLeftCorner.equals(other.topLeftCorner));
    }
}

