/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.search;

import java.util.ArrayList;
import java.util.List;

public class SearchParams {
    private int maxDepth = 0;
    private List<String> patterns;
    private boolean skipDirs = true;
    private boolean skipFiles = false;
    private String[] patternsArray;

    public SearchParams() {
    }

    public SearchParams(String pattern) {
        this.getPatterns().add(pattern);
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MaxDepth: " + (this.maxDepth == 0 ? "unlimited" : Integer.valueOf(this.maxDepth)) + "\n");
        sb.append("SkipDirs: " + this.skipDirs + "\n");
        sb.append("SkipFiles: " + this.skipFiles + "\n");
        sb.append("Patterns: ");
        for (String s : this.getPatterns()) {
            sb.append(s);
            sb.append(" ");
        }
        sb.append("\n");
        return sb.toString();
    }

    public List<String> getPatterns() {
        if (this.patterns == null) {
            this.patterns = new ArrayList<String>();
        }
        return this.patterns;
    }

    public void setPatterns(List<String> patterns) {
        this.patterns = patterns;
    }

    public boolean isSkipDirs() {
        return this.skipDirs;
    }

    public void setSkipDirs(boolean skipDirs) {
        this.skipDirs = skipDirs;
    }

    public boolean isSkipFiles() {
        return this.skipFiles;
    }

    public void setSkipFiles(boolean skipFiles) {
        this.skipFiles = skipFiles;
    }

    public String[] getPatternsArray() {
        if (this.patternsArray == null) {
            this.patternsArray = new String[this.patterns.size()];
            for (int i = 0; i < this.patterns.size(); ++i) {
                String s;
                this.patternsArray[i] = s = this.patterns.get(i).replace("\"", "").replace(".", "\\.").replace("*", "(.)*").replace("?", "(.){1}").toLowerCase();
            }
        }
        return this.patternsArray;
    }

    public void setPatternsArray(String[] patternsArray) {
        this.patternsArray = patternsArray;
    }

    public Boolean isNoPatterns() {
        return this.patterns == null || this.patterns.size() == 0;
    }
}

