/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.multicore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import main.java.guru.vfrflight.bean.constants.Constants;
import org.apache.log4j.Logger;

public abstract class ListRunner<T> {
    private static final Logger log = Logger.getLogger(ListRunner.class);
    private List<T> toProcessList;
    private int tasksNum;

    public ListRunner(List<T> toProcessList, int tasksNum) {
        this.toProcessList = toProcessList;
        this.tasksNum = tasksNum;
    }

    public List<T> process() {
        ExecutorService pool = Executors.newFixedThreadPool(Constants.NTHREDS);
        ArrayList<Future<List<T>>> futureTasks = new ArrayList<Future<List<T>>>(this.tasksNum);
        int groupSize = Math.round(this.toProcessList.size() / this.tasksNum);
        for (int i = 0; i <= this.tasksNum - 2; ++i) {
            futureTasks.add(pool.submit(this.processChunk(this.toProcessList.subList(i * groupSize, i * groupSize + groupSize))));
        }
        futureTasks.add(pool.submit(this.processChunk(this.toProcessList.subList((this.tasksNum - 1) * groupSize, this.toProcessList.size()))));
        ArrayList resultList = new ArrayList(this.toProcessList.size());
        for (Future future : futureTasks) {
            try {
                resultList.addAll((Collection)future.get());
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                log.error(e, e);
            }
        }
        pool.shutdown();
        return resultList;
    }

    protected abstract Callable<List<T>> processChunk(List<T> var1);
}

