/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.gps;

import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.util.GpsUtil;

public class RouteSegment
extends LineSegment {
    private double Kz;
    private double W;
    private long t;
    private long eta;
    private boolean selected = false;
    private boolean phantom = false;
    private Double climbRate;
    private Double climbAngle;

    public RouteSegment(LineSegment segment) {
        this.from = segment.getFrom();
        this.to = segment.getTo();
        this.course = segment.getCourse();
        this.magneticCourse = segment.getMagneticCourse();
        this.distance = segment.getDistance();
        this.diagonalDistance = segment.getDiagonalDistance();
        this.rectangleOver = segment.getRectangleOver();
    }

    public RouteSegment() {
    }

    public double getKz() {
        return this.Kz;
    }

    public void setKz(double kz) {
        this.Kz = kz;
    }

    public double getW() {
        return this.W;
    }

    public void setW(double W) {
        this.W = W;
    }

    public long getT() {
        return this.t;
    }

    public void setT(long t) {
        this.t = t;
    }

    public long getEta() {
        return this.eta;
    }

    public void setEta(long eta) {
        this.eta = eta;
    }

    public Double getKm() {
        if (this.getMagneticCourse() != null) {
            return GpsUtil.normalizeCourse(this.getMagneticCourse() + this.getKz());
        }
        return null;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isPhantom() {
        return this.phantom;
    }

    public void setPhantom(boolean phantom) {
        this.phantom = phantom;
    }

    public Double getClimbRate() {
        return this.climbRate;
    }

    public void setClimbRate(Double climbRate) {
        this.climbRate = climbRate;
    }

    public Double getClimbAngle() {
        return this.climbAngle;
    }

    public void setClimbAngle(Double climbAngle) {
        this.climbAngle = climbAngle;
    }
}

