/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.gps;

import java.util.ArrayList;
import java.util.List;
import main.java.guru.vfrflight.core.gps.Area;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsVertex;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.util.GpsUtil;

public class RotatedGpsArea
extends Area {
    private GpsPlace topLeft;
    private GpsPlace topRight;
    private GpsPlace bottomLeft;
    private GpsPlace bottomRight;
    private GpsPlace center;
    private double angle = 0.0;
    public static int SEGMENT_TOP = 0;
    public static int SEGMENT_LEFT = 1;
    public static int SEGMENT_BOTTOM = 2;
    public static int SEGMENT_RIGHT = 3;

    public RotatedGpsArea(GpsArea area) {
        this(area.getTopLeft(), area.getTopRight(), area.getBottomLeft(), area.getBottomRight(), 0.0);
    }

    public RotatedGpsArea(GpsPlace topLeft, GpsPlace topRight, GpsPlace bottomLeft, GpsPlace bottomRight, double angle) {
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomLeft = bottomLeft;
        this.bottomRight = bottomRight;
        this.angle = angle;
        this.center = new GpsPlace((topLeft.getLat().getValue() + bottomRight.getLat().getValue()) / 2.0, (topLeft.getLon().getValue() + bottomRight.getLon().getValue()) / 2.0);
    }

    @Override
    public GpsPlace getTopLeft() {
        return this.topLeft;
    }

    public void setTopLeft(GpsPlace topLeft) {
        this.topLeft = topLeft;
    }

    @Override
    public GpsPlace getTopRight() {
        return this.topRight;
    }

    public void setTopRight(GpsPlace topRight) {
        this.topRight = topRight;
    }

    @Override
    public GpsPlace getBottomLeft() {
        return this.bottomLeft;
    }

    public void setBottomLeft(GpsPlace bottomLeft) {
        this.bottomLeft = bottomLeft;
    }

    @Override
    public GpsPlace getBottomRight() {
        return this.bottomRight;
    }

    public void setBottomRight(GpsPlace bottomRight) {
        this.bottomRight = bottomRight;
    }

    public GpsPlace getCenter() {
        return this.center;
    }

    public void setCenter(GpsPlace center) {
        this.center = center;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public GpsArea getRectangleOver() {
        ArrayList<GpsVertex> vertices = new ArrayList<GpsVertex>(4);
        vertices.add(this.topLeft);
        vertices.add(this.topRight);
        vertices.add(this.bottomRight);
        vertices.add(this.bottomLeft);
        return GpsUtil.getRectangleOverVertices(vertices);
    }

    public List<LineSegment> getSegments() {
        ArrayList<LineSegment> segments = new ArrayList<LineSegment>(4);
        segments.add(new LineSegment(this.topLeft, this.topRight));
        segments.add(new LineSegment(this.topLeft, this.bottomLeft));
        segments.add(new LineSegment(this.bottomLeft, this.bottomRight));
        segments.add(new LineSegment(this.topRight, this.bottomRight));
        return segments;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RotatedGpsArea [topLeft=");
        builder.append(this.topLeft);
        builder.append(", topRight=");
        builder.append(this.topRight);
        builder.append(", bottomLeft=");
        builder.append(this.bottomLeft);
        builder.append(", bottomRight=");
        builder.append(this.bottomRight);
        builder.append(", center=");
        builder.append(this.center);
        builder.append(", angle=");
        builder.append(this.angle);
        builder.append("]");
        return builder.toString();
    }
}

