/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.gps;

import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.util.GpsUtil;

public class LineSegment {
    protected GpsPlace from;
    protected GpsPlace to;
    protected Double course;
    protected Double magneticCourse;
    protected Double distance;
    protected Double diagonalDistance;
    protected GpsArea rectangleOver;

    public Double getCourse() {
        return this.course;
    }

    public void setCourse(Double course) {
        this.course = course;
    }

    public Double getMagneticVariation() {
        if (this.course == null || this.magneticCourse == null) {
            return null;
        }
        return this.course - this.magneticCourse;
    }

    public void setMagneticVariation(Double magvar) {
        if (this.course != null && magvar != null) {
            this.magneticCourse = GpsUtil.normalizeCourse(this.course - magvar);
        }
    }

    public Double getMagneticCourse() {
        return this.magneticCourse;
    }

    public void setMagneticCourse(Double magneticCourse) {
        this.magneticCourse = magneticCourse;
    }

    public Double getDistance() {
        return this.distance;
    }

    public void setDistance(Double distance) {
        this.distance = distance;
    }

    public LineSegment(GpsPlace from, GpsPlace to) {
        this.from = from;
        this.to = to;
    }

    public LineSegment(GpsPlace from, GpsPlace to, Double course) {
        this(from, to);
        this.course = course;
    }

    public LineSegment(GpsPlace from, GpsPlace to, Double distance, Double course) {
        this(from, to, course);
        this.distance = distance;
    }

    public LineSegment() {
    }

    public GpsPlace getFrom() {
        return this.from;
    }

    public void setFrom(GpsPlace from) {
        this.from = from;
    }

    public GpsPlace getTo() {
        return this.to;
    }

    public void setTo(GpsPlace to) {
        this.to = to;
    }

    public String getSegmentName() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.from.getName());
        builder.append(" => ");
        builder.append(this.to.getName());
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LineSegment [from=");
        builder.append(this.from);
        builder.append(", to=");
        builder.append(this.to);
        builder.append(", course=");
        builder.append(this.course);
        builder.append(", magneticCourse=");
        builder.append(this.magneticCourse);
        builder.append(", distance=");
        builder.append(this.distance);
        builder.append(", diagonalDistance=");
        builder.append(this.diagonalDistance);
        builder.append(", rectangleOver=");
        builder.append(this.rectangleOver);
        builder.append("]");
        return builder.toString();
    }

    public Double getDiagonalDistance() {
        return this.diagonalDistance;
    }

    public void setDiagonalDistance(Double diagonalDistance) {
        this.diagonalDistance = diagonalDistance;
    }

    public boolean isInside(GpsArea area) {
        return this.getRectangleOver().isInside(area) || area.isInside(this.getRectangleOver());
    }

    public GpsArea getRectangleOver() {
        if (this.rectangleOver == null) {
            double minLat = this.getFrom().getLat().getValue() <= this.getTo().getLat().getValue() ? this.getFrom().getLat().getValue() : this.getTo().getLat().getValue();
            double minLon = this.getFrom().getLon().getValue() <= this.getTo().getLon().getValue() ? this.getFrom().getLon().getValue() : this.getTo().getLon().getValue();
            double maxLat = this.getFrom().getLat().getValue() >= this.getTo().getLat().getValue() ? this.getFrom().getLat().getValue() : this.getTo().getLat().getValue();
            double maxLon = this.getFrom().getLon().getValue() >= this.getTo().getLon().getValue() ? this.getFrom().getLon().getValue() : this.getTo().getLon().getValue();
            this.rectangleOver = new GpsArea(maxLat, minLon, minLat, maxLon);
        }
        return this.rectangleOver;
    }

    public void setRectangleOver(GpsArea rectangleOver) {
        this.rectangleOver = rectangleOver;
    }

    public GpsPlace getOffset(double offset) {
        double dlat = this.getTo().getLat().getValue() - this.getFrom().getLat().getValue();
        double dlon = this.getTo().getLon().getValue() - this.getFrom().getLon().getValue();
        double lat = this.getFrom().getLat().getValue() + dlat * offset;
        double lon = this.getFrom().getLon().getValue() + dlon * offset;
        return new GpsPlace(new GpsCoord(lat), new GpsCoord(lon));
    }

    public GpsPlace getCenter() {
        return this.getOffset(0.5);
    }

    public double getOrCalculateDistance() {
        if (this.getDistance() == null) {
            this.setDistance(GpsUtil.getDistance(this.getFrom(), this.getTo()));
        }
        return this.getDistance();
    }
}

