/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.gps;

import java.awt.geom.Point2D;

public class GpsPoint
extends Point2D {
    double x;
    double y;

    public GpsPoint(double x, double y) {
        this.setLocation(x, y);
    }

    public GpsPoint(Point2D point) {
        this(point.getX(), point.getY());
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GpsPoint(");
        builder.append(this.x);
        builder.append(", ");
        builder.append(this.y);
        builder.append(")");
        return builder.toString();
    }

    public boolean isBetween(Point2D wp1, Point2D wp2) {
        return this.isBetween(wp1, wp2, 0.0);
    }

    public boolean isBetween(Point2D wp1, Point2D wp2, double tolerance) {
        if (wp1.getX() > wp2.getX() || wp1.getY() > wp2.getY()) {
            Point2D wp3 = wp2;
            wp2 = wp1;
            wp1 = wp3;
        }
        double x = wp1.getX() < wp2.getX() ? wp1.getX() : wp2.getX();
        double y = wp1.getY() < wp2.getY() ? wp1.getY() : wp2.getY();
        double ax = wp1.getX() > wp2.getX() ? wp1.getX() : wp2.getX();
        double ay = wp1.getY() > wp2.getY() ? wp1.getY() : wp2.getY();
        return this.x >= x - tolerance && this.y >= y - tolerance && this.x <= ax + tolerance && this.y <= ay + tolerance;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }
}

