/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.gps;

import java.util.HashMap;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsVertex;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class GpsPlace
implements GpsVertex {
    protected GpsCoord lat;
    protected GpsCoord lon;
    protected String name = "";
    protected Double alt;
    protected String desc = "";
    protected String type;
    protected HashMap<String, Object> data;
    public static final String DATA_FREQUENCY = "freq";
    public static final String DATA_MAIN_RWY = "mainRwy";
    public static final String DATA_MAIN_LENGTH = "mainLength";
    public static final String DATA_HEADING = "heading";
    public static final String DATA_WIDTH = "width";
    public static final String DATA_PITCH = "pitch";
    public static final String DATA_MAGVAR = "magvar";
    public static final String DATA_REMARK = "remark";
    public static final String DATA_DISTANCE = "dist";
    public static final String DATA_ELEVATION = "elev";

    @Override
    public GpsCoord getLat() {
        return this.lat;
    }

    public GeoPosition geoPosition() {
        return new GeoPosition(this.getLat().getValue(), this.getLon().getValue());
    }

    public void setLat(GpsCoord lat) {
        if (Math.abs(lat.getValue()) > 90.0) {
            boolean minusVal = lat.isMinusValue();
            lat.setValue(180.0 - Math.abs(lat.getValue()));
            lat.setMinusValue(!minusVal);
        }
        this.lat = lat;
    }

    @Override
    public GpsCoord getLon() {
        return this.lon;
    }

    public void setLon(GpsCoord lon) {
        if (Math.abs(lon.getValue()) > 180.0) {
            boolean minusVal = lon.isMinusValue();
            lon.setValue(360.0 - Math.abs(lon.getValue()));
            lon.setMinusValue(!minusVal);
        }
        this.lon = lon;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GpsPlace() {
    }

    public GpsPlace(double lat, double lon) {
        this.setLat(new GpsCoord(lat));
        this.setLon(new GpsCoord(lon));
    }

    public GpsPlace(double lat, double lon, double alt) {
        this.setLat(new GpsCoord(lat));
        this.setLon(new GpsCoord(lon));
        this.setAlt(alt);
    }

    public GpsPlace(GpsCoord lat, GpsCoord lon) {
        this.setLat(lat);
        this.setLon(lon);
    }

    public GpsPlace(GpsCoord lat, GpsCoord lon, String name) {
        this.setLat(lat);
        this.setLon(lon);
        this.name = name;
    }

    public GpsPlace(GpsCoord lat, GpsCoord lon, String name, Double alt, String type) {
        this.setLat(lat);
        this.setLon(lon);
        this.name = name;
        this.alt = alt;
        this.type = type;
    }

    public GpsPlace(double lat, double lon, String name, Double alt) {
        this(lat, lon);
        this.name = name;
        this.alt = alt;
    }

    public GpsPlace(GpsCoord lat, GpsCoord lon, String name, Double alt) {
        this.setLat(lat);
        this.setLon(lon);
        this.name = name;
        this.alt = alt;
    }

    public GpsPlace(String coords) {
        GpsPlace parsed = FormatUtil.stringToGpsPlace(coords);
        if (parsed != null) {
            this.setLat(parsed.getLat());
            this.setLon(parsed.getLon());
            this.name = parsed.getName();
        }
    }

    public GpsPlace(String coords, String name) {
        this(coords);
        this.name = name;
    }

    public Double getAlt() {
        return this.alt;
    }

    public void setAlt(Double alt) {
        this.alt = alt;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getLatHemisphere() {
        return !this.lat.isMinusValue() ? "N" : "S";
    }

    public void setLatHemisphere(String hem) {
        this.lat.setMinusValue("S".equals(hem));
    }

    public void setLonHemisphere(String hem) {
        this.lon.setMinusValue("W".equals(hem));
    }

    public String getLonHemisphere() {
        return !this.lon.isMinusValue() ? "E" : "W";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        builder.append(", ");
        builder.append(this.desc);
        builder.append("[");
        builder.append(this.lat);
        builder.append(this.getLatHemisphere());
        builder.append(", ");
        builder.append(this.lon);
        builder.append(this.getLonHemisphere());
        builder.append(", ");
        builder.append(this.alt);
        builder.append("]");
        return builder.toString();
    }

    public GpsPlace clone() {
        GpsPlace clone = new GpsPlace();
        clone.setAlt(this.getAlt());
        clone.setLat(this.getLat());
        clone.setLon(this.getLon());
        clone.setName(this.getName());
        clone.setDesc(this.getDesc());
        clone.setType(this.getType());
        clone.setData(this.data);
        return clone;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alt == null ? 0 : this.alt.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
        result = 31 * result + (this.lat == null ? 0 : this.lat.hashCode());
        result = 31 * result + (this.lon == null ? 0 : this.lon.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GpsPlace other = (GpsPlace)obj;
        if (this.alt == null ? other.alt != null : !this.alt.equals(other.alt)) {
            return false;
        }
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
            return false;
        }
        if (this.lat == null ? other.lat != null : !this.lat.equals(other.lat)) {
            return false;
        }
        if (this.lon == null ? other.lon != null : !this.lon.equals(other.lon)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean isInside(GpsArea area) {
        if (area == null) {
            return false;
        }
        return this.lat.getValue() <= area.getMaxLat() && this.lat.getValue() >= area.getMinLat() && this.lon.getValue() >= area.getMinLon() && this.lon.getValue() <= area.getMaxLon();
    }

    @Override
    public boolean isArc() {
        return false;
    }

    @Override
    public boolean isVertex() {
        return true;
    }

    @Override
    public GpsPlace getPoint() {
        return this;
    }

    public HashMap<String, Object> getData() {
        if (this.data == null) {
            this.data = new HashMap();
        }
        return this.data;
    }

    public void setData(HashMap<String, Object> data) {
        this.data = data;
    }

    public Integer getDataInt(String name) {
        if (this.data != null && this.data.containsKey(name)) {
            return (Integer)this.data.get(name);
        }
        return null;
    }

    public void setDataInt(String name, int val) {
        if (this.getData().containsKey(name)) {
            this.getData().remove(name);
        }
        this.getData().put(name, val);
    }

    public Double getDataDouble(String name) {
        if (this.data != null && this.data.containsKey(name)) {
            return (Double)this.data.get(name);
        }
        return null;
    }

    public void setDataDouble(String name, Double val) {
        if (this.getData().containsKey(name)) {
            this.getData().remove(name);
        }
        this.getData().put(name, val);
    }

    public void setDataString(String name, String val) {
        if (this.getData().containsKey(name)) {
            this.getData().remove(name);
        }
        this.getData().put(name, val);
    }

    public boolean isNdb() {
        return "NDB".equals(this.type);
    }

    public boolean isVor() {
        return "VOR".equals(this.type) || "VOR-DME".equals(this.type);
    }

    public boolean isDme() {
        return "DME".equals(this.type) || "VOR-DME".equals(this.type);
    }

    public UserPoint getUserPoint() {
        UserPoint place = new UserPoint();
        place.setLat(this.getLat().getValue());
        place.setLon(this.getLon().getValue());
        place.setName(this.getName());
        place.setTags(this.getDesc());
        return place;
    }

    public void move(double diffLat, double diffLon) {
        this.getLat().setValue(GpsUtil.normalizeLatitude(this.getLat().getValue() + diffLat));
        this.getLon().setValue(GpsUtil.normalizeLongitude(this.getLon().getValue() + diffLon));
    }

    public Double getMagvar() {
        return this.getDataDouble(DATA_MAGVAR);
    }

    public double getLatVal() {
        return this.lat.getValue();
    }

    public double getLonVal() {
        return this.lon.getValue();
    }
}

