/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.gps;

import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.NumberUtil;

public class GpsCoord {
    private double value;
    private int deg;
    private int min;
    private double sec;

    public GpsCoord clone() {
        return new GpsCoord(this.value);
    }

    private void calculateDegMinSec() {
        this.deg = (int)Math.floor(Math.abs(this.value));
        this.min = (int)Math.floor((Math.abs(this.value) - (double)this.deg) * 60.0);
        if (this.min >= 60) {
            this.min -= 60;
            ++this.deg;
        }
        this.sec = NumberUtil.roundDouble(((Math.abs(this.value) - (double)this.deg) * 60.0 - (double)this.min) * 60.0, 1);
        if (this.sec >= 60.0) {
            this.sec -= 60.0;
            ++this.min;
            if (this.min >= 60) {
                this.min -= 60;
                ++this.deg;
            }
        }
    }

    public int getDeg() {
        return this.deg;
    }

    public int getMin() {
        return this.min;
    }

    public double getSec() {
        return this.sec;
    }

    public GpsCoord(double value) {
        this.value = value;
        this.calculateDegMinSec();
    }

    public boolean hasOnlyDegComponent() {
        return this.getMin() == 0 && NumberUtil.doubleEqualsZero(this.getSec());
    }

    public boolean hasNoSecComponent() {
        return NumberUtil.doubleEqualsZero(this.getSec());
    }

    public GpsCoord(int deg, int min, double sec) {
        this.value = (double)Math.abs(deg) + (double)Math.abs(min) / 60.0 + Math.abs(sec) / 3600.0;
        if (deg < 0) {
            this.value = -this.value;
        }
        this.calculateDegMinSec();
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
        this.calculateDegMinSec();
    }

    public double getRadians() {
        return Math.toRadians(this.getValue());
    }

    public String toString() {
        return FormatUtil.formatCoord(this);
    }

    public void setMinusValue(boolean minusValue) {
        if (minusValue != this.isMinusValue()) {
            this.value = -this.value;
            this.calculateDegMinSec();
        }
    }

    public boolean isMinusValue() {
        return NumberUtil.doubleLessThanZero(this.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.deg;
        result = 31 * result + this.min;
        long temp = Double.doubleToLongBits(this.sec);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GpsCoord other = (GpsCoord)obj;
        if (this.deg != other.deg) {
            return false;
        }
        if (this.min != other.min) {
            return false;
        }
        if (Double.doubleToLongBits(this.sec) != Double.doubleToLongBits(other.sec)) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }
}

