/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.gps;

import main.java.guru.vfrflight.core.gps.Area;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class GpsArea
extends Area {
    public static int VERTEX_TOP_LEFT = 0;
    public static int VERTEX_TOP_RIGHT = 1;
    public static int VERTEX_BOTTOM_LEFT = 2;
    public static int VERTEX_BOTTOM_RIGHT = 3;
    private Double minLat;
    private Double maxLat;
    private Double minLon;
    private Double maxLon;

    public GpsArea(GpsPlace center, double radiusNm) {
        this(GpsUtil.getPointPositionByDistanceAndBearing(center, 315.0, radiusNm), GpsUtil.getPointPositionByDistanceAndBearing(center, 135.0, radiusNm));
    }

    public GpsArea(double topLeftLat, double topLeftLon, double bottomRightLat, double bottomRightLon) {
        this.maxLat = topLeftLat;
        this.minLon = topLeftLon;
        this.minLat = bottomRightLat;
        this.maxLon = bottomRightLon;
    }

    public GpsArea(GpsPlace topLeft, GpsPlace bottomRight) {
        this.calculateCorners(topLeft, bottomRight);
    }

    public GpsArea(GeoPosition lastGp, GeoPosition gp) {
        this(lastGp.gpsPlace(), gp.gpsPlace());
    }

    private void calculateCorners(GpsPlace topLeft, GpsPlace bottomRight) {
        this.minLat = topLeft.getLat().getValue() <= bottomRight.getLat().getValue() ? topLeft.getLat().getValue() : bottomRight.getLat().getValue();
        this.minLon = topLeft.getLon().getValue() <= bottomRight.getLon().getValue() ? topLeft.getLon().getValue() : bottomRight.getLon().getValue();
        this.maxLat = topLeft.getLat().getValue() >= bottomRight.getLat().getValue() ? topLeft.getLat().getValue() : bottomRight.getLat().getValue();
        this.maxLon = topLeft.getLon().getValue() >= bottomRight.getLon().getValue() ? topLeft.getLon().getValue() : bottomRight.getLon().getValue();
    }

    @Override
    public GpsPlace getTopLeft() {
        return new GpsPlace(new GpsCoord(this.maxLat), new GpsCoord(this.minLon));
    }

    @Override
    public GpsPlace getBottomRight() {
        return new GpsPlace(new GpsCoord(this.minLat), new GpsCoord(this.maxLon));
    }

    @Override
    public GpsPlace getTopRight() {
        return new GpsPlace(new GpsCoord(this.maxLat), new GpsCoord(this.maxLon));
    }

    @Override
    public GpsPlace getBottomLeft() {
        return new GpsPlace(new GpsCoord(this.minLat), new GpsCoord(this.minLon));
    }

    public boolean isInside(GpsArea area) {
        if (area.contains(this.maxLat, this.minLon) || area.contains(this.maxLat, this.maxLon) || area.contains(this.minLat, this.minLon) || area.contains(this.minLat, this.maxLon)) {
            return true;
        }
        return area.getMaxLat() >= this.maxLat && area.getMinLat() <= this.minLat && area.getMinLon() >= this.minLon && area.getMaxLon() <= this.maxLon;
    }

    public GpsPlace getCenter() {
        return new GpsPlace((this.minLat + this.maxLat) / 2.0, (this.minLon + this.maxLon) / 2.0);
    }

    public boolean contains(GpsPlace place) {
        return this.contains(place.getLat().getValue(), place.getLon().getValue());
    }

    public boolean contains(GeoPosition geo) {
        return this.contains(geo.getLatitude(), geo.getLongitude());
    }

    public boolean contains(double lat, double lon) {
        return lat <= this.maxLat && lat >= this.minLat && lon >= this.minLon && lon <= this.maxLon;
    }

    public void expand(double degrees) {
        this.minLon = this.minLon - degrees;
        if (this.minLon < -180.0) {
            this.minLon = -180.0;
        }
        this.maxLon = this.maxLon + degrees;
        if (this.maxLon > 180.0) {
            this.maxLon = 180.0;
        }
        this.minLat = this.minLat - degrees;
        if (this.minLat < -90.0) {
            this.minLat = -90.0;
        }
        this.maxLat = this.maxLat + degrees;
        if (this.maxLat > 90.0) {
            this.maxLat = 90.0;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GpsArea [minLat=");
        builder.append(this.minLat);
        builder.append(", maxLat=");
        builder.append(this.maxLat);
        builder.append(", minLon=");
        builder.append(this.minLon);
        builder.append(", maxLon=");
        builder.append(this.maxLon);
        builder.append("]");
        return builder.toString();
    }

    public GpsArea clone() {
        return new GpsArea(this.maxLat, this.minLon, this.minLat, this.maxLon);
    }

    public Double getMinLat() {
        return this.minLat;
    }

    public void setMinLat(Double minLat) {
        this.minLat = minLat;
    }

    public Double getMaxLat() {
        return this.maxLat;
    }

    public void setMaxLat(Double maxLat) {
        this.maxLat = maxLat;
    }

    public Double getMinLon() {
        return this.minLon;
    }

    public void setMinLon(Double minLon) {
        this.minLon = minLon;
    }

    public Double getMaxLon() {
        return this.maxLon;
    }

    public void setMaxLon(Double maxLon) {
        this.maxLon = maxLon;
    }

    public String getKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(NumberUtil.roundDouble(this.minLat)));
        sb.append(String.valueOf(NumberUtil.roundDouble(this.maxLat)));
        sb.append(String.valueOf(NumberUtil.roundDouble(this.minLon)));
        sb.append(String.valueOf(NumberUtil.roundDouble(this.maxLon)));
        return sb.toString();
    }
}

