/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.gl;

public class GlVector {
    public float x = 0.0f;
    public float y = 0.0f;
    public float z = 0.0f;
    public static final float PIOVER180 = (float)Math.PI / 180;
    public static final float PIUNDER180 = 57.29578f;

    public GlVector() {
    }

    public GlVector(float xpos, float ypos, float zpos) {
        this.x = xpos;
        this.y = ypos;
        this.z = zpos;
    }

    public GlVector(float[] float3) {
        this.x = float3[0];
        this.y = float3[1];
        this.z = float3[2];
    }

    public GlVector(GlVector v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public GlVector(GlVector point1, GlVector point2) {
        this.x = point1.x - point2.x;
        this.y = point1.y - point2.y;
        this.z = point1.z - point2.z;
    }

    public GlVector add(GlVector v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public GlVector sub(GlVector v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    public GlVector mult(GlVector v) {
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
        return this;
    }

    public GlVector div(GlVector v) {
        this.x /= v.x;
        this.y /= v.y;
        this.z /= v.z;
        return this;
    }

    public GlVector add(float n) {
        this.x += n;
        this.y += n;
        this.z += n;
        return this;
    }

    public GlVector sub(float n) {
        this.x -= n;
        this.y -= n;
        this.z -= n;
        return this;
    }

    public GlVector mult(float n) {
        this.x *= n;
        this.y *= n;
        this.z *= n;
        return this;
    }

    public GlVector div(float n) {
        this.x /= n;
        this.y /= n;
        this.z /= n;
        return this;
    }

    public GlVector normalize() {
        float len = this.length();
        if (len == 0.0f) {
            return this;
        }
        float invlen = 1.0f / len;
        this.x *= invlen;
        this.y *= invlen;
        this.z *= invlen;
        return this;
    }

    public GlVector reverse() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.x);
        builder.append("; ");
        builder.append(this.y);
        builder.append("; ");
        builder.append(this.z);
        builder.append("]");
        return builder.toString();
    }

    public GlVector getClone() {
        return new GlVector(this.x, this.y, this.z);
    }

    public boolean equals(GlVector v) {
        return v.x == this.x && v.y == this.y && v.z == this.z;
    }

    public static GlVector add(GlVector a, GlVector b) {
        return new GlVector(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    public static GlVector sub(GlVector a, GlVector b) {
        return new GlVector(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    public static GlVector mult(GlVector a, GlVector b) {
        return new GlVector(a.x * b.x, a.y * b.y, a.z * b.z);
    }

    public static GlVector div(GlVector a, GlVector b) {
        return new GlVector(a.x / b.x, a.y / b.y, a.z / b.z);
    }

    public static GlVector multiply(GlVector v, float r) {
        return new GlVector(v.x * r, v.y * r, v.z * r);
    }

    public static GlVector scale(GlVector a, float f) {
        return new GlVector(f * a.x, f * a.y, f * a.z);
    }

    public static float length(GlVector a) {
        return (float)Math.sqrt(a.x * a.x + a.y * a.y + a.z * a.z);
    }

    public static float dotProduct(GlVector u, GlVector v) {
        return u.x * v.x + u.y * v.y + u.z * v.z;
    }

    public static GlVector normalize(GlVector v) {
        float len = v.length();
        if (len == 0.0f) {
            return v;
        }
        float invlen = 1.0f / len;
        return new GlVector(v.x * invlen, v.y * invlen, v.z * invlen);
    }

    public static GlVector crossProduct(GlVector a, GlVector b) {
        return GlVector.vectorProduct(a, b).normalize();
    }

    public static GlVector getNormal(GlVector a, GlVector b) {
        return GlVector.vectorProduct(a, b).normalize();
    }

    public static GlVector getNormal(GlVector a, GlVector b, GlVector c) {
        return GlVector.vectorProduct(a, b, c).normalize();
    }

    public static GlVector vectorProduct(GlVector a, GlVector b) {
        return new GlVector(a.y * b.z - b.y * a.z, a.z * b.x - b.z * a.x, a.x * b.y - b.x * a.y);
    }

    public static GlVector vectorProduct(GlVector a, GlVector b, GlVector c) {
        return GlVector.vectorProduct(GlVector.sub(b, a), GlVector.sub(c, a));
    }

    public static float angle(GlVector a, GlVector b) {
        a.normalize();
        b.normalize();
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    public static float angleXZ(GlVector a, GlVector b) {
        a.normalize();
        b.normalize();
        return (float)((Math.atan2(a.x * b.z - b.x * a.z, a.x * b.x + a.z * b.z) + Math.PI) * 0.01745329238474369);
    }

    public static float angleXY(GlVector a, GlVector b) {
        a.normalize();
        b.normalize();
        return (float)((Math.atan2(a.x * b.y - b.x * a.y, a.x * b.x + a.y * b.y) + Math.PI) * (double)57.29578f);
    }

    public static GlVector rotationVector(float degrees) {
        return new GlVector((float)Math.sin(degrees * ((float)Math.PI / 180)), 0.0f, (float)Math.cos(degrees * ((float)Math.PI / 180)));
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getZ() {
        return this.z;
    }

    public void setZ(float z) {
        this.z = z;
    }
}

