/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.gl;

import java.util.Arrays;
import main.java.guru.vfrflight.core.gl.GlPoint;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.UnitUtil;

public class GlPointTransformer {
    private static final float SCALE_CONSTANT_FACTOR = 10.0f;
    private final GpsArea area;
    private final float[] scale;
    private float[] offset;

    public GlPointTransformer(GpsArea area) {
        this.area = area;
        this.scale = this.getScaleXYZ();
        this.offset = this.getOffset();
    }

    public GlPoint getPoint(float lon, float lat, float alt) {
        return new GlPoint((lon + this.offset[0]) * this.scale[0], (lat + this.offset[1]) * this.scale[1], alt * this.scale[2]);
    }

    private float[] getOffset() {
        float[] result = new float[]{-((float)((this.area.getMaxLon() + this.area.getMinLon()) / 2.0)), -((float)((this.area.getMaxLat() + this.area.getMinLat()) / 2.0))};
        return result;
    }

    private float[] getScaleXYZ() {
        double distLon = UnitUtil.recalculateDistance(GpsUtil.getLonDistance(this.area), "nm", "km", false);
        double distLat = UnitUtil.recalculateDistance(GpsUtil.getLatDistance(this.area), "nm", "km", false);
        float scale = 25.0f / (float)Math.sqrt(distLon * distLon + distLat * distLat);
        float[] result = new float[]{(float)(distLon / (this.area.getMaxLon() - this.area.getMinLon())) * scale * 10.0f, (float)(distLat / (this.area.getMaxLat() - this.area.getMinLat())) * scale * 10.0f, 0.001f * scale * 10.0f};
        return result;
    }

    public float[] getScale() {
        return this.scale;
    }

    public void setOffset(float[] offset) {
        this.offset = offset;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GlPointTransformer [area=");
        builder.append(this.area);
        builder.append(", scale=");
        builder.append(Arrays.toString(this.scale));
        builder.append(", offset=");
        builder.append(Arrays.toString(this.offset));
        builder.append("]");
        return builder.toString();
    }
}

