/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.gl;

import javax.media.opengl.GL2;

public class GlLineStroke {
    private final float width;
    private final Integer factor;
    private final Short pattern;

    public GlLineStroke(float width) {
        this(width, null, null);
    }

    public GlLineStroke(float width, Integer factor, Short pattern) {
        this.width = width;
        this.factor = factor;
        this.pattern = pattern;
    }

    public void enable(GL2 gl) {
        gl.glLineWidth(this.width);
        if (this.factor != null && this.pattern != null) {
            gl.glEnable(2852);
            gl.glLineStipple(this.factor.intValue(), this.pattern.shortValue());
        } else {
            gl.glDisable(2852);
        }
    }

    public void disable(GL2 gl) {
        gl.glLineWidth(1.0f);
        if (this.factor != null && this.pattern != null) {
            gl.glDisable(2852);
        }
    }

    public float getWidth() {
        return this.width;
    }

    public Integer getFactor() {
        return this.factor;
    }

    public Short getPattern() {
        return this.pattern;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GlLineStroke [width=");
        builder.append(this.width);
        builder.append(", factor=");
        builder.append(this.factor);
        builder.append(", pattern=");
        builder.append(this.pattern);
        builder.append("]");
        return builder.toString();
    }
}

