/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.dto;

import java.util.HashMap;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.gui.map.NamedWaypoint;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class WaypointDTO
extends NamedWaypoint {
    private boolean selected;
    private boolean phantom;
    private Double alt;
    private HashMap<String, Object> data;
    private String type;

    public WaypointDTO() {
    }

    public WaypointDTO(Airport airport) {
        super(new GeoPosition(airport.getLat(), airport.getLon()), airport.getIdent());
        GpsPlace place = airport.getGpsPlace();
        this.setData(place.getData());
        this.setType(place.getType());
        if (airport.getElev() != null) {
            this.setAlt(airport.getElev().doubleValue());
        }
    }

    public WaypointDTO(UserPoint point) {
        super(new GeoPosition(point.getLat(), point.getLon()), point.getName());
        this.setType("PT");
    }

    public WaypointDTO(GpsPlace place) {
        super(new GeoPosition(place.getLat().getValue(), place.getLon().getValue()), place.getName());
        this.setData(place.getData());
        this.setType(place.getType());
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean isSelected) {
        this.selected = isSelected;
    }

    public boolean isPhantom() {
        return this.phantom;
    }

    public void setPhantom(boolean phantom) {
        this.phantom = phantom;
    }

    public Double getAlt() {
        return this.alt;
    }

    public void setAlt(Double alt) {
        this.alt = alt;
    }

    public HashMap<String, Object> getData() {
        if (this.data == null) {
            this.data = new HashMap();
        }
        return this.data;
    }

    public void setData(HashMap<String, Object> data) {
        this.data = data;
    }

    public Integer getDataInt(String name) {
        if (this.data != null && this.data.containsKey(name)) {
            return (Integer)this.data.get(name);
        }
        return null;
    }

    public void setDataInt(String name, int freq) {
        if (this.getData().containsKey(name)) {
            this.getData().remove(name);
        }
        this.getData().put(name, freq);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Double getDataDouble(String name) {
        if (this.data != null && this.data.containsKey(name)) {
            return (Double)this.data.get(name);
        }
        return null;
    }

    public void setDataDouble(String name, Double val) {
        if (this.getData().containsKey(name)) {
            this.getData().remove(name);
        }
        this.getData().put(name, val);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VfrMapWaypoint [selected=");
        builder.append(this.selected);
        builder.append(", phantom=");
        builder.append(this.phantom);
        builder.append(", alt=");
        builder.append(this.alt);
        builder.append(", data=");
        builder.append(this.data);
        builder.append(", type=");
        builder.append(this.type);
        builder.append("]");
        return builder.toString();
    }

    public String getAirportInfo() {
        StringBuilder sb = new StringBuilder();
        if (this.getName() != null) {
            sb.append(this.getName());
        } else {
            sb.append("---");
        }
        if (this.getDataInt("elev") != null) {
            int elev = this.getDataInt("elev");
            if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                elev = (int)UnitUtil.recalculateAltitude(elev, "ft", SettingsBean.getInstance().getParamUnitsAltitude(), true);
            }
            sb.append(" ");
            sb.append(elev);
            sb.append(SettingsBean.getInstance().getParamUnitsAltitude());
        }
        if (this.getDataInt("mainLength") != null) {
            if (this.getDataInt("elev") != null) {
                sb.append(" - ");
            }
            sb.append(this.getDataInt("mainLength"));
            sb.append("m");
        }
        return sb.toString();
    }

    public String getNavaidInfoName(boolean ndb) {
        return this.getName() != null ? StringUtil.nullToEmpty(this.getName()) : "---";
    }

    public String getNavaidInfoFrequency(boolean ndb) {
        return ndb ? StringUtil.nullToEmpty(FormatUtil.formatNdbFrequency(this.getDataInt("freq"))) : StringUtil.nullToEmpty(FormatUtil.formatVorFrequency(this.getDataInt("freq")));
    }

    public String getNavaidInfo(boolean ndb) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getNavaidInfoName(ndb));
        if (this.getDataInt("freq") != null) {
            sb.append(" ");
            sb.append(this.getNavaidInfoFrequency(ndb));
        }
        return sb.toString();
    }

    public Double getMagvar() {
        return this.getDataDouble("magvar");
    }
}

