/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.dto;

import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.sql.entity.Taxiway;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class TaxiwayPathDTO {
    private String name;
    private GeoPosition[] boundary = null;
    private GpsArea rectangleOver = null;

    public TaxiwayPathDTO(Taxiway t) {
        this.name = t.getName();
        LineSegment segment = GpsUtil.getLineSegment(t.getFrom(), t.getTo());
        if (segment.getCourse() != null) {
            this.boundary = GpsUtil.calculateBoundaryForLineSegment(segment, UnitUtil.recalculateDistance(t.getWidth(), "m", "nm", false), 45);
            this.rectangleOver = this.calculateRectangleOver();
        }
    }

    public GpsArea getRectangleOver() {
        return this.rectangleOver;
    }

    public GpsArea calculateRectangleOver() {
        if (this.boundary == null) {
            return null;
        }
        double minLat = 500.0;
        double minLon = 500.0;
        double maxLat = -500.0;
        double maxLon = -500.0;
        for (GeoPosition t : this.boundary) {
            if (t.getLatitude() < minLat) {
                minLat = t.getLatitude();
            } else if (t.getLatitude() > maxLat) {
                maxLat = t.getLatitude();
            }
            if (t.getLongitude() < minLon) {
                minLon = t.getLongitude();
                continue;
            }
            if (!(t.getLongitude() > maxLon)) continue;
            maxLon = t.getLongitude();
        }
        return new GpsArea(maxLat, minLon, minLat, maxLon);
    }

    public void setRectangleOver(GpsArea rectangleOver) {
        this.rectangleOver = rectangleOver;
    }

    public boolean isInside(GpsArea area) {
        if (this.rectangleOver == null) {
            return false;
        }
        return this.rectangleOver.isInside(area) || area.isInside(this.rectangleOver);
    }

    public GeoPosition[] getBoundary() {
        return this.boundary;
    }

    public void setBoundary(GeoPosition[] boundary) {
        this.boundary = boundary;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

