/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.dto;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import main.java.guru.vfrflight.core.dto.AirportDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.Runway;
import main.java.guru.vfrflight.util.ColorUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class RunwayExtensionDTO {
    private static Color[] PALETTE = VfrUtil.generateColorsPalette(360, 1.0f);
    private final GeoPosition[] vertices;
    private GpsArea rectangleOver;
    private final Color[] colors;
    private final String name;
    private final Integer elev;
    private final double heading;
    private AirportDTO airport;

    public RunwayExtensionDTO(Runway r, String name, Integer elev, boolean primary, Airport airport) {
        GpsPlace center = r.getGpsPlace();
        double halfLengthInNm = UnitUtil.recalculateDistance(r.getLength(), "m", "nm", false) / 2.0;
        this.heading = primary ? r.getTrueHeading() : GpsUtil.normalizeCourse(180.0 + r.getTrueHeading());
        this.vertices = new GeoPosition[7];
        this.colors = new Color[6];
        for (int i = 0; i < this.vertices.length; ++i) {
            this.vertices[i] = GpsUtil.getPointPositionByDistanceAndBearing(center, this.heading, halfLengthInNm + (double)i * 5.0).geoPosition();
            if (i <= 0) continue;
            Color color = PALETTE[(int)Math.round(this.heading) % 360];
            this.colors[i - 1] = color = ColorUtil.newColorWithOpacity(color, 0.1f * (float)(this.vertices.length - 1 - i) + 0.225f);
        }
        this.rectangleOver = new LineSegment(this.vertices[0].gpsPlace(), this.vertices[this.vertices.length - 1].gpsPlace()).getRectangleOver();
        this.name = name;
        this.elev = elev;
        if (airport != null) {
            this.airport = new AirportDTO(airport);
        }
    }

    public GpsArea getRectangleOver() {
        return this.rectangleOver;
    }

    public void setRectangleOver(GpsArea rectangleOver) {
        this.rectangleOver = rectangleOver;
    }

    public boolean isInside(GpsArea area) {
        return this.rectangleOver.isInside(area) || area.isInside(this.rectangleOver);
    }

    public GeoPosition[] getVertices() {
        return this.vertices;
    }

    public Color[] getColors() {
        return this.colors;
    }

    public String getName() {
        return this.name;
    }

    public Integer getElev() {
        return this.elev;
    }

    public double getHeading() {
        return this.heading;
    }

    public AirportDTO getAirport() {
        return this.airport;
    }

    public void setAirport(AirportDTO airport) {
        this.airport = airport;
    }

    public List<LineSegment> getSegments() {
        ArrayList<LineSegment> segments = new ArrayList<LineSegment>(this.vertices.length - 1);
        for (int i = 1; i < this.vertices.length; ++i) {
            segments.add(new LineSegment(this.vertices[i - 1].gpsPlace(), this.vertices[i].gpsPlace()));
        }
        return segments;
    }
}

