/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.dto;

import java.util.ArrayList;
import java.util.List;
import main.java.guru.vfrflight.core.dto.IlsDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsVertex;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.sql.entity.Ils;
import main.java.guru.vfrflight.core.sql.entity.Runway;
import main.java.guru.vfrflight.core.sql.type.RunwayDesignator;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.org.jdesktop.swingx.mapviewer.DefaultWaypoint;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;
import main.java.org.jdesktop.swingx.mapviewer.Waypoint;

public class RunwayDTO
extends DefaultWaypoint
implements Waypoint {
    private Integer elev;
    private Double length;
    private Double width;
    private Integer number;
    private RunwayDesignator designator;
    private RunwayDesignator secondaryDesignator;
    private Double heading;
    private Double magvar;
    private List<IlsDTO> ils;
    private GpsVertex[] boundary = null;
    private GpsArea rectangleOver = null;
    public static final String NAME_PREFIX = "RWY ";

    public RunwayDTO(Runway runway) {
        this(runway, false);
    }

    public RunwayDTO(Runway runway, boolean withChildren) {
        if (runway.getLat() != null && runway.getLon() != null) {
            this.setPosition(new GeoPosition(runway.getLat(), runway.getLon()));
        }
        this.heading = runway.getHeading();
        this.elev = runway.getElev();
        this.length = runway.getLength();
        this.width = runway.getWidth();
        this.number = runway.getNumber();
        this.designator = runway.getDesignator();
        this.secondaryDesignator = runway.getSecondaryDesignator();
        this.heading = runway.getHeading();
        this.magvar = runway.getMagvar();
        if (withChildren && runway.getIls().size() > 0) {
            this.ils = new ArrayList<IlsDTO>();
            for (Ils i : runway.getIls()) {
                this.ils.add(new IlsDTO(i, null));
            }
        }
        this.calculateBoundary();
    }

    public Integer getElev() {
        return this.elev;
    }

    public void setElev(Integer elev) {
        this.elev = elev;
    }

    public Double getLength() {
        return this.length;
    }

    public void setLength(Double length) {
        this.length = length;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public RunwayDesignator getDesignator() {
        return this.designator;
    }

    public void setDesignator(RunwayDesignator designator) {
        this.designator = designator;
    }

    public RunwayDesignator getSecondaryDesignator() {
        return this.secondaryDesignator;
    }

    public void setSecondaryDesignator(RunwayDesignator secondaryDesignator) {
        this.secondaryDesignator = secondaryDesignator;
    }

    public Double getHeading() {
        return this.heading;
    }

    public void setHeading(Double heading) {
        this.heading = heading;
    }

    public Double getPrimaryHeading() {
        int num = GpsUtil.getPrimaryRwyNumberFromHeading(this.heading);
        if (Math.abs(num - this.number) > 10) {
            return GpsUtil.normalizeCourse(this.heading + 180.0);
        }
        return this.heading;
    }

    public Double getSecondaryHeading() {
        if (this.heading != null) {
            return GpsUtil.normalizeCourse(this.getPrimaryHeading() + 180.0);
        }
        return this.heading;
    }

    public List<IlsDTO> getIls() {
        return this.ils;
    }

    public void setIls(List<IlsDTO> ils) {
        this.ils = ils;
    }

    public IlsDTO getPrimaryRwyIls() {
        if (this.number != null && this.ils != null) {
            for (IlsDTO i : this.ils) {
                if (!(Math.abs(i.getHeading() - this.getPrimaryHeading()) < 45.0)) continue;
                return i;
            }
        }
        return null;
    }

    public IlsDTO getSecondaryRwyIls() {
        if (this.number != null && this.ils != null) {
            for (IlsDTO i : this.ils) {
                if (!(Math.abs(i.getHeading() - this.getSecondaryHeading()) < 45.0)) continue;
                return i;
            }
        }
        return null;
    }

    public GpsPlace getPrimaryThresholdPosition() {
        LineSegment lineSegment = this.getLineSegment();
        if (lineSegment != null) {
            return lineSegment.getFrom();
        }
        return null;
    }

    public GpsPlace getSecondaryThresholdPosition() {
        LineSegment lineSegment = this.getLineSegment();
        if (lineSegment != null) {
            return lineSegment.getTo();
        }
        return null;
    }

    public LineSegment getLineSegment() {
        if (this.heading != null && this.length != null && this.number != null && this.magvar != null) {
            double correction = UnitUtil.recalculateDistance(this.length, "m", "nm", false) / 2.0;
            GpsPlace primaryThreshold = GpsUtil.getPointPositionByDistanceAndBearing(this.getPosition().gpsPlace(), GpsUtil.normalizeCourse(this.getPrimaryHeading() + this.magvar + 180.0), correction);
            GpsPlace secondaryThreshold = GpsUtil.getPointPositionByDistanceAndBearing(this.getPosition().gpsPlace(), GpsUtil.normalizeCourse(this.getPrimaryHeading() + this.magvar), correction);
            return new LineSegment(primaryThreshold, secondaryThreshold);
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RunwayDTO [lat=");
        builder.append(this.getPosition().getLatitude());
        builder.append(", lon=");
        builder.append(this.getPosition().getLongitude());
        builder.append(", elev=");
        builder.append(this.elev);
        builder.append(", length=");
        builder.append(this.length);
        builder.append(", width=");
        builder.append(this.width);
        builder.append(", number=");
        builder.append(this.number);
        builder.append(", designator=");
        builder.append((Object)this.designator);
        builder.append(", secondaryDesignator=");
        builder.append((Object)this.secondaryDesignator);
        builder.append(", heading=");
        builder.append(this.heading);
        builder.append(", magvar=");
        builder.append(this.magvar);
        builder.append(", ils=");
        builder.append(this.ils);
        builder.append("]");
        return builder.toString();
    }

    public Integer getPrimaryNumber() {
        return this.number;
    }

    public Integer getSecondaryNumber() {
        if (this.number != null) {
            return GpsUtil.normalizeRunwayNumber(this.number + 18);
        }
        return null;
    }

    public String getPrimaryInfo() {
        StringBuilder sb = new StringBuilder(NAME_PREFIX);
        if (this.number != null) {
            sb.append(this.getPrimaryNumber());
            if (this.designator != null) {
                sb.append((Object)this.designator);
            }
        }
        return sb.toString();
    }

    public String getPrimaryName() {
        String name = this.getPrimaryInfo();
        if (name.length() <= NAME_PREFIX.length()) {
            return null;
        }
        return name.substring(NAME_PREFIX.length());
    }

    public String getSecondaryInfo() {
        StringBuilder sb = new StringBuilder(NAME_PREFIX);
        if (this.number != null) {
            sb.append(this.getSecondaryNumber());
            if (this.secondaryDesignator != null) {
                sb.append((Object)this.secondaryDesignator);
            }
        }
        return sb.toString();
    }

    public String getSecondaryName() {
        String name = this.getSecondaryInfo();
        if (name.length() <= NAME_PREFIX.length()) {
            return null;
        }
        return name.substring(NAME_PREFIX.length());
    }

    public void calculateBoundary() {
        LineSegment lineSegment = this.getLineSegment();
        if (lineSegment != null && this.width != null && this.magvar != null) {
            ArrayList<GpsVertex> boundaryList = new ArrayList<GpsVertex>(4);
            double correction = UnitUtil.recalculateDistance(this.width, "m", "nm", false) / 2.0;
            boundaryList.add(GpsUtil.getPointPositionByDistanceAndBearing(lineSegment.getFrom(), GpsUtil.normalizeCourse(this.heading + this.magvar + 90.0), correction));
            boundaryList.add(GpsUtil.getPointPositionByDistanceAndBearing(lineSegment.getFrom(), GpsUtil.normalizeCourse(this.heading + this.magvar + 270.0), correction));
            boundaryList.add(GpsUtil.getPointPositionByDistanceAndBearing(lineSegment.getTo(), this.heading + this.magvar - 90.0, correction));
            boundaryList.add(GpsUtil.getPointPositionByDistanceAndBearing(lineSegment.getTo(), GpsUtil.normalizeCourse(this.heading + this.magvar + 90.0), correction));
            this.rectangleOver = GpsUtil.getRectangleOverVertices(boundaryList);
            this.boundary = boundaryList.toArray(new GpsVertex[boundaryList.size()]);
        }
    }

    public GpsArea getRectangleOver() {
        if (this.rectangleOver == null) {
            this.calculateBoundary();
        }
        return this.rectangleOver;
    }

    public void setRectangleOver(GpsArea rectangleOver) {
        this.rectangleOver = rectangleOver;
    }

    public GpsVertex[] getBoundary() {
        if (this.boundary == null) {
            this.calculateBoundary();
        }
        return this.boundary;
    }

    public void setBoundary(GpsVertex[] boundary) {
        this.boundary = boundary;
    }

    public boolean isInside(GpsArea area) {
        if (this.rectangleOver == null) {
            this.calculateBoundary();
        }
        if (this.rectangleOver != null) {
            return this.rectangleOver.isInside(area) || area.isInside(this.rectangleOver);
        }
        return false;
    }

    public Double getMagvar() {
        return this.magvar;
    }

    public void setMagvar(Double magvar) {
        this.magvar = magvar;
    }
}

