/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.dto;

import java.awt.Color;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class RadialFromVorDTO {
    private GeoPosition from;
    private GeoPosition to;
    private String desc;
    private GpsArea rectangleOver;
    private int radial;
    private boolean major;
    private Color color;
    private String vorId;
    private boolean selected = false;

    public RadialFromVorDTO(String vorId, int radial, GeoPosition from, GeoPosition to, String desc, boolean major, Color color) {
        this.vorId = vorId;
        this.radial = radial;
        this.from = from;
        this.to = to;
        this.desc = desc;
        this.major = major;
        this.color = color;
    }

    public String getVorId() {
        return this.vorId;
    }

    public void setVorId(String vorId) {
        this.vorId = vorId;
    }

    public GeoPosition getFrom() {
        return this.from;
    }

    public void setFrom(GeoPosition from) {
        this.from = from;
    }

    public GeoPosition getTo() {
        return this.to;
    }

    public void setTo(GeoPosition to) {
        this.to = to;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public int getRadial() {
        return this.radial;
    }

    public void setRadial(int radial) {
        this.radial = radial;
    }

    public boolean isMajor() {
        return this.major;
    }

    public void setMajor(boolean major) {
        this.major = major;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public GpsArea getRectangleOver() {
        if (this.rectangleOver == null) {
            double minLat = this.getFrom().getLatitude() <= this.getTo().getLatitude() ? this.getFrom().getLatitude() : this.getTo().getLatitude();
            double minLon = this.getFrom().getLongitude() <= this.getTo().getLongitude() ? this.getFrom().getLongitude() : this.getTo().getLongitude();
            double maxLat = this.getFrom().getLatitude() >= this.getTo().getLatitude() ? this.getFrom().getLatitude() : this.getTo().getLatitude();
            double maxLon = this.getFrom().getLongitude() >= this.getTo().getLongitude() ? this.getFrom().getLongitude() : this.getTo().getLongitude();
            this.rectangleOver = new GpsArea(maxLat, minLon, minLat, maxLon);
        }
        return this.rectangleOver;
    }

    public boolean isInside(GpsArea area) {
        return this.getRectangleOver().isInside(area) || area.isInside(this.getRectangleOver());
    }

    public void setRectangleOver(GpsArea rectangleOver) {
        this.rectangleOver = rectangleOver;
    }

    public LineSegment getLineSegment() {
        return new LineSegment(this.from.gpsPlace(), this.to.gpsPlace());
    }

    public String getUniqueId() {
        return this.vorId + "_" + this.radial;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

