/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.dto;

import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.sql.entity.Obstacle;
import main.java.guru.vfrflight.gui.map.NamedWaypoint;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class ObstacleDTO
extends NamedWaypoint
implements Comparable<ObstacleDTO> {
    private Integer agl;
    private Integer amsl;
    private boolean grp;
    private boolean lgt;
    private boolean high = false;
    private String desc;

    public ObstacleDTO(Obstacle obstacle) {
        this.setPosition(new GeoPosition(obstacle.getLat(), obstacle.getLon()));
        this.setName(obstacle.getName());
        this.desc = obstacle.getDesc();
        this.agl = obstacle.getAgl();
        this.amsl = obstacle.getAmsl();
        this.grp = obstacle.isGrp();
        this.lgt = obstacle.isLgt();
        if (obstacle.getAgl() != null) {
            this.high = obstacle.getAgl() >= 1000;
        }
    }

    public Integer getAgl() {
        return this.agl;
    }

    public void setAgl(Integer agl) {
        this.agl = agl;
    }

    public Integer getAmsl() {
        return this.amsl;
    }

    public void setAmsl(Integer amsl) {
        this.amsl = amsl;
    }

    public boolean isGrp() {
        return this.grp;
    }

    public void setGrp(boolean grp) {
        this.grp = grp;
    }

    public boolean isLgt() {
        return this.lgt;
    }

    public void setLgt(boolean lgt) {
        this.lgt = lgt;
    }

    public boolean isHigh() {
        return this.high;
    }

    public void setHigh(boolean high) {
        this.high = high;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        if (this.getName() != null) {
            sb.append(this.getName());
        }
        if (this.desc != null) {
            sb.append(" - " + this.desc);
        }
        if (this.amsl != null) {
            sb.append(" - " + this.amsl + SettingsBean.getInstance().getParamUnitsAltitude());
        }
        if (this.agl != null) {
            sb.append(" (" + this.agl + SettingsBean.getInstance().getParamUnitsAltitude() + ")");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(ObstacleDTO o) {
        if (o == null) {
            return -1;
        }
        if (this.amsl == null || o.getAmsl() == null) {
            if (this.agl != null && o.getAgl() == null) {
                return -1;
            }
            if (this.agl == null && o.getAgl() != null) {
                return 1;
            }
            return -this.agl.compareTo(o.getAgl());
        }
        if (this.amsl != null && o.getAmsl() == null) {
            return -1;
        }
        if (this.amsl == null && o.getAmsl() != null) {
            return 1;
        }
        return -this.amsl.compareTo(o.getAmsl());
    }
}

