/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.dto;

import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Navaid;
import main.java.guru.vfrflight.gui.map.NamedWaypoint;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class NavaidDTO
extends NamedWaypoint {
    private Integer id;
    private Double magvar;
    private Integer alt;
    private Integer freq;
    private String type;
    private String remark;

    public NavaidDTO() {
    }

    public NavaidDTO(Navaid ndb) {
        super(new GeoPosition(ndb.getLat(), ndb.getLon()), ndb.getIdent());
        this.remark = ndb.getRemark();
        this.magvar = ndb.getMagvar();
        this.freq = ndb.getFreq();
        this.type = ndb.getType();
        this.alt = ndb.getAlt();
    }

    public Integer getAlt() {
        return this.alt;
    }

    public void setAlt(Integer alt) {
        this.alt = alt;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getInfoName() {
        return this.getName() != null ? StringUtil.nullToEmpty(this.getName()) : "---";
    }

    public String getInfoFrequency() {
        return this.isNdb() ? StringUtil.nullToEmpty(FormatUtil.formatNdbFrequency(this.freq)) : StringUtil.nullToEmpty(FormatUtil.formatVorFrequency(this.freq));
    }

    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getInfoName());
        if (this.freq != null) {
            sb.append(" ");
            sb.append(this.getInfoFrequency());
        }
        return sb.toString();
    }

    public Integer getFreq() {
        return this.freq;
    }

    public void setFreq(Integer freq) {
        this.freq = freq;
    }

    public Double getMagvar() {
        return this.magvar;
    }

    public void setMagvar(Double magvar) {
        this.magvar = magvar;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public boolean isNdb() {
        return "NDB".equals(this.type);
    }

    @Override
    public GpsPlace getGpsPlace() {
        return new GpsPlace(new GpsCoord(this.getPosition().getLatitude()), new GpsCoord(this.getPosition().getLongitude()), this.getName(), this.alt != null ? Double.valueOf(this.alt.intValue()) : null);
    }
}

