/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.dto;

import java.util.Arrays;
import main.java.guru.vfrflight.core.dto.RunwayDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsVertex;
import main.java.org.jdesktop.swingx.mapviewer.DefaultWaypoint;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;
import main.java.org.jdesktop.swingx.mapviewer.Waypoint;

public class MapRunwayDTO
extends DefaultWaypoint
implements Waypoint {
    private GpsVertex[] boundary;
    private GpsArea rectangleOver;
    private GeoPosition primaryThresholdPos;
    private GeoPosition secondaryThresholdPos;
    private String primaryRunwayName;
    private String secondaryRunwayName;

    public MapRunwayDTO(RunwayDTO runway) {
        GpsPlace secondaryThreshold;
        this.setPosition(new GeoPosition(this.getPosition().getLatitude(), this.getPosition().getLongitude()));
        this.rectangleOver = runway.getRectangleOver();
        this.boundary = runway.getBoundary();
        GpsPlace primaryThreshold = runway.getPrimaryThresholdPosition();
        if (primaryThreshold != null) {
            this.primaryThresholdPos = primaryThreshold.geoPosition();
            this.primaryRunwayName = runway.getPrimaryName();
        }
        if ((secondaryThreshold = runway.getSecondaryThresholdPosition()) != null) {
            this.secondaryThresholdPos = secondaryThreshold.geoPosition();
            this.secondaryRunwayName = runway.getSecondaryName();
        }
    }

    public GpsArea getRectangleOver() {
        return this.rectangleOver;
    }

    public void setRectangleOver(GpsArea rectangleOver) {
        this.rectangleOver = rectangleOver;
    }

    public GpsVertex[] getBoundary() {
        return this.boundary;
    }

    public void setBoundary(GpsVertex[] boundary) {
        this.boundary = boundary;
    }

    public boolean isInside(GpsArea area) {
        if (this.rectangleOver != null) {
            return this.rectangleOver.isInside(area) || area.isInside(this.rectangleOver);
        }
        return false;
    }

    public GeoPosition getPrimaryThresholdPos() {
        return this.primaryThresholdPos;
    }

    public GeoPosition getSecondaryThresholdPos() {
        return this.secondaryThresholdPos;
    }

    public String getPrimaryRunwayName() {
        return this.primaryRunwayName;
    }

    public String getSecondaryRunwayName() {
        return this.secondaryRunwayName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MapRunwayDTO [boundary=");
        builder.append(Arrays.toString(this.boundary));
        builder.append(", rectangleOver=");
        builder.append(this.rectangleOver);
        builder.append("]");
        return builder.toString();
    }
}

