/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.dto;

import java.util.ArrayList;
import main.java.guru.vfrflight.core.dto.AirportDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsVertex;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.Ils;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.mapviewer.DefaultWaypoint;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;
import main.java.org.jdesktop.swingx.mapviewer.Waypoint;

public class IlsDTO
extends DefaultWaypoint
implements Waypoint {
    private Double heading;
    private Double magvar;
    private Double width;
    private Double pitch;
    private Integer frequency;
    private String name;
    private GpsArea boundary;
    private boolean dme;
    private boolean gs;
    private Integer alt;
    private AirportDTO airport;
    public static final String NAME_PREFIX = "ILS ";
    public static final double DEFAULT_RANGE = 15.0;

    public IlsDTO(Ils ils, Airport airport) {
        this.setPosition(new GeoPosition(ils.getLat(), ils.getLon()));
        this.heading = ils.getHeading();
        this.magvar = ils.getMagvar();
        this.width = ils.getWidth();
        this.pitch = ils.getPitch();
        this.frequency = (int)Math.round(ils.getFrequency() * 1000.0);
        this.name = ils.getIdent();
        this.dme = ils.isDme();
        this.gs = ils.isGs();
        this.alt = ils.getAlt();
        if (airport != null) {
            this.airport = new AirportDTO(airport);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VfrMapIls [heading=");
        builder.append(this.heading);
        builder.append(", magvar=");
        builder.append(this.magvar);
        builder.append(", width=");
        builder.append(this.width);
        builder.append(", pitch=");
        builder.append(this.pitch);
        builder.append(", frequency=");
        builder.append(this.frequency);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", airport=");
        builder.append(this.airport);
        builder.append(", boundary=");
        builder.append(this.boundary);
        builder.append(", dme=");
        builder.append(this.dme);
        builder.append(", gs=");
        builder.append(this.gs);
        builder.append(", alt=");
        builder.append(this.alt);
        builder.append("]");
        return builder.toString();
    }

    public void calculateBoundary(JXMapViewer map) {
        ArrayList<GpsVertex> points = new ArrayList<GpsVertex>();
        GpsPlace startPoint = this.getPosition().gpsPlace();
        points.add(startPoint);
        points.add(GpsUtil.getPointPositionByDistanceAndBearing(startPoint, GpsUtil.normalizeCourse(this.heading + 180.0), 16.0));
        points.add(GpsUtil.getPointPositionByDistanceAndBearing(startPoint, GpsUtil.normalizeCourse(this.heading + 180.0 - this.width / 2.0), 16.0));
        points.add(GpsUtil.getPointPositionByDistanceAndBearing(startPoint, GpsUtil.normalizeCourse(this.heading + 180.0 + this.width / 2.0), 16.0));
        this.boundary = GpsUtil.getRectangleOverVertices(points);
    }

    public IlsDTO() {
    }

    public boolean isInside(GpsArea area) {
        return this.boundary.isInside(area) || area.isInside(this.boundary);
    }

    public Double getHeading() {
        return this.heading;
    }

    public void setHeading(Double heading) {
        this.heading = heading;
    }

    public Double getMagvar() {
        return this.magvar;
    }

    public void setMagvar(Double magvar) {
        this.magvar = magvar;
    }

    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public Double getPitch() {
        return this.pitch;
    }

    public void setPitch(Double pitch) {
        this.pitch = pitch;
    }

    public Integer getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Integer frequency) {
        this.frequency = frequency;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GpsArea getBoundary() {
        return this.boundary;
    }

    public void setBoundary(GpsArea boundary) {
        this.boundary = boundary;
    }

    public Integer getAlt() {
        return this.alt;
    }

    public void setAlt(Integer alt) {
        this.alt = alt;
    }

    public Double getMagHeading() {
        Double hdg = null;
        if (this.heading != null) {
            hdg = this.heading;
            if (this.magvar != null) {
                hdg = GpsUtil.normalizeCourse(hdg - this.magvar);
            }
        }
        return hdg;
    }

    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(NAME_PREFIX);
        sb.append(this.getName());
        sb.append(" ");
        sb.append(this.getShortInfo());
        if (this.isDme() && this.isGs()) {
            sb.append(" [DME,GS]");
        } else if (this.isDme() && !this.isGs()) {
            sb.append(" [DME]");
        } else if (!this.isDme() && this.isGs()) {
            sb.append(" [GS]");
        }
        return sb.toString();
    }

    public String getShortInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(FormatUtil.formatVorFrequency(this.getFrequency()));
        sb.append(" / ");
        sb.append((int)Math.round(this.getMagHeading()));
        sb.append("\u00b0");
        return sb.toString();
    }

    public Integer getPrimaryRwyNumber() {
        if (this.heading != null) {
            return GpsUtil.getPrimaryRwyNumberFromHeading(this.getMagHeading());
        }
        return null;
    }

    public Integer getSecondaryRwyNumber() {
        if (this.heading != null) {
            return GpsUtil.getSecondaryRwyNumberFromHeading(this.getMagHeading());
        }
        return null;
    }

    public GpsPlace getGpsPlace() {
        GpsPlace place = this.getPosition().gpsPlace();
        place.setDataDouble("heading", this.getHeading());
        place.setDataDouble("pitch", this.getPitch());
        place.setDataInt("elev", this.getAlt());
        return place;
    }

    public boolean isDme() {
        return this.dme;
    }

    public void setDme(boolean dme) {
        this.dme = dme;
    }

    public boolean isGs() {
        return this.gs;
    }

    public void setGs(boolean gs) {
        this.gs = gs;
    }

    public AirportDTO getAirport() {
        return this.airport;
    }

    public void setAirport(AirportDTO airport) {
        this.airport = airport;
    }

    public String getAirportCode() {
        if (this.airport == null) {
            return null;
        }
        return this.airport.getName();
    }
}

