/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.dto;

import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Route;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class IfrRouteDTO {
    private String name;
    private String remark;
    private GeoPosition previous;
    private GeoPosition next;
    private GpsArea rectangleOver;
    private double heading;

    public IfrRouteDTO(Route route) {
        this.name = route.getName();
        this.remark = route.getRemark();
        this.previous = new GeoPosition(route.getFromLat(), route.getFromLon());
        this.next = new GeoPosition(route.getToLat(), route.getToLon());
        GpsPlace from = this.previous.gpsPlace();
        GpsPlace to = this.next.gpsPlace();
        this.rectangleOver = new GpsArea(from, to);
        this.heading = GpsUtil.getCourse(from, to);
    }

    public IfrRouteDTO() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isInside(GpsArea area) {
        return this.rectangleOver.isInside(area) || area.isInside(this.rectangleOver);
    }

    public GeoPosition getNext() {
        return this.next;
    }

    public GeoPosition getPrevious() {
        return this.previous;
    }

    public void setPrevious(GeoPosition previous) {
        this.previous = previous;
    }

    public GpsArea getRectangleOver() {
        return this.rectangleOver;
    }

    public void setRectangleOver(GpsArea rectangleOver) {
        this.rectangleOver = rectangleOver;
    }

    public void setNext(GeoPosition next) {
        this.next = next;
    }

    public double getHeading() {
        return this.heading;
    }

    public void setHeading(double heading) {
        this.heading = heading;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}

