/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.dto;

import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.sql.entity.Apron;
import main.java.guru.vfrflight.core.sql.entity.ApronVertex;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class ApronDTO {
    private GeoPosition[] boundary = null;
    private GpsArea rectangleOver = null;

    public ApronDTO(Apron a) {
        if (a.getVertices().size() > 0) {
            this.boundary = new GeoPosition[a.getVertices().size()];
            for (int i = 0; i < a.getVertices().size(); ++i) {
                ApronVertex v = a.getVertices().get(i);
                this.boundary[i] = new GeoPosition(v.getLat(), v.getLon());
            }
        }
        this.rectangleOver = this.calculateRectangleOver();
    }

    public GpsArea getRectangleOver() {
        return this.rectangleOver;
    }

    public GpsArea calculateRectangleOver() {
        double minLat = 500.0;
        double minLon = 500.0;
        double maxLat = -500.0;
        double maxLon = -500.0;
        for (GeoPosition t : this.boundary) {
            if (t.getLatitude() < minLat) {
                minLat = t.getLatitude();
            } else if (t.getLatitude() > maxLat) {
                maxLat = t.getLatitude();
            }
            if (t.getLongitude() < minLon) {
                minLon = t.getLongitude();
                continue;
            }
            if (!(t.getLongitude() > maxLon)) continue;
            maxLon = t.getLongitude();
        }
        return new GpsArea(maxLat, minLon, minLat, maxLon);
    }

    public void setRectangleOver(GpsArea rectangleOver) {
        this.rectangleOver = rectangleOver;
    }

    public boolean isInside(GpsArea area) {
        return this.rectangleOver.isInside(area) || area.isInside(this.rectangleOver);
    }

    public GeoPosition[] getBoundary() {
        return this.boundary;
    }

    public void setBoundary(GeoPosition[] boundary) {
        this.boundary = boundary;
    }
}

