/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.dto;

import java.awt.Color;
import java.awt.Stroke;
import java.util.List;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.core.sql.entity.AirspaceAreaVertex;
import main.java.guru.vfrflight.core.sql.type.AirspaceType;
import main.java.guru.vfrflight.core.sql.type.AltitudeType;
import main.java.guru.vfrflight.gui.map.shape.MapShape;
import main.java.guru.vfrflight.gui.map.shape.MapShapeVertex;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class AirspaceAreaDTO
extends MapShape
implements Comparable<AirspaceAreaDTO> {
    private Integer id;
    private String name;
    private String remark;
    private Integer bottomAltitude;
    private AltitudeType bottomAltitudeType;
    private Integer topAltitude;
    private AltitudeType topAltitudeType;
    private AirspaceType type;
    private List<GeoPosition> origins;

    @Override
    public AirspaceAreaDTO clone() {
        AirspaceAreaDTO a = new AirspaceAreaDTO();
        a.setBottomAltitude(this.bottomAltitude);
        a.setBottomAltitudeType(this.bottomAltitudeType);
        a.setId(this.id);
        a.setName(this.name);
        a.setTopAltitude(this.topAltitude);
        a.setTopAltitudeType(this.topAltitudeType);
        a.setType(this.type);
        a.setBackgroundColor(this.getBackgroundColor());
        a.setCenter(this.getCenter());
        a.setCircleCenterLat(this.getCircleCenterLat());
        a.setCircleCenterLon(this.getCircleCenterLon());
        a.setColor(this.getBackgroundColor());
        a.setRadius(this.getRadius());
        a.setRectangleOver(this.getRectangleOver());
        a.setStroke(this.getStroke());
        a.setSecondaryStroke(this.getSecondaryStroke());
        a.setSecondaryStrokeColor(this.getSecondaryStrokeColor());
        a.setRemark(this.remark);
        a.setVertices(this.getVertices());
        return a;
    }

    public AirspaceAreaDTO() {
    }

    public AirspaceAreaDTO(AirspaceArea a) {
        MapShapeVertex[] vertices = new MapShapeVertex[a.getVertices().size()];
        int i = 0;
        for (AirspaceAreaVertex aav : a.getVertices()) {
            vertices[i] = new MapShapeVertex(aav);
            ++i;
        }
        this.setVertices(vertices);
        this.id = a.getId();
        this.name = a.getName();
        this.bottomAltitude = a.getBottomAltitude();
        this.bottomAltitudeType = a.getBottomAltitudeType();
        this.topAltitude = a.getTopAltitude();
        this.topAltitudeType = a.getTopAltitudeType();
        this.setRadius(a.getRadius());
        this.setCircleCenterLat(a.getCircleCenterLat());
        this.setCircleCenterLon(a.getCircleCenterLon());
        this.type = a.getType();
        this.setCenter(a.getCenter());
        this.origins = a.getOrigins();
        this.remark = a.getRemark();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getBottomAltitude() {
        return this.bottomAltitude;
    }

    public void setBottomAltitude(Integer bottomAltitude) {
        this.bottomAltitude = bottomAltitude;
    }

    public AltitudeType getBottomAltitudeType() {
        return this.bottomAltitudeType;
    }

    public void setBottomAltitudeType(AltitudeType bottomAltitudeType) {
        this.bottomAltitudeType = bottomAltitudeType;
    }

    public Integer getTopAltitude() {
        return this.topAltitude;
    }

    public void setTopAltitude(Integer topAltitude) {
        this.topAltitude = topAltitude;
    }

    public AltitudeType getTopAltitudeType() {
        return this.topAltitudeType;
    }

    public void setTopAltitudeType(AltitudeType topAltitudeType) {
        this.topAltitudeType = topAltitudeType;
    }

    public AirspaceType getType() {
        return this.type;
    }

    public void setType(AirspaceType type) {
        this.type = type;
    }

    public boolean isBetween(Integer altFrom, Integer altTo) {
        if (altFrom == null && altTo == null) {
            return true;
        }
        if (this.bottomAltitude != null && this.topAltitude != null) {
            return altTo != null && altFrom != null ? this.bottomAltitude <= altTo && altTo <= this.topAltitude || this.bottomAltitude <= altFrom && altFrom <= this.topAltitude || altFrom <= this.bottomAltitude && altTo >= this.topAltitude : altTo != null && altTo >= this.bottomAltitude || altFrom != null && altFrom <= this.topAltitude;
        }
        if (this.bottomAltitude != null && this.topAltitude == null) {
            return altFrom != null && altFrom <= this.bottomAltitude || altTo != null && altTo >= this.bottomAltitude;
        }
        if (this.bottomAltitude == null && this.topAltitude != null) {
            return altFrom != null && altFrom <= this.topAltitude || altTo != null && altTo <= this.topAltitude;
        }
        return true;
    }

    public boolean isBottomUnlimited() {
        return this.getBottomAltitude() == null || this.getBottomAltitude() <= 0;
    }

    public boolean isTopUnlimited() {
        return this.getTopAltitude() == null;
    }

    public boolean isUnlimited() {
        return this.isBottomUnlimited() && this.isTopUnlimited();
    }

    @Override
    public Color getBackgroundColor() {
        return SettingsBean.getInstance().getAirspacesColorTheme().getAirspaceBackground(this.getType());
    }

    @Override
    public Stroke getStroke() {
        return SettingsBean.getInstance().getAirspacesColorTheme().getAirspaceStroke(this.getType());
    }

    @Override
    public Color getColor() {
        return SettingsBean.getInstance().getAirspacesColorTheme().getAirspaceColor(this.getType());
    }

    @Override
    public Stroke getSecondaryStroke() {
        return SettingsBean.getInstance().getAirspacesColorTheme().getAirspaceSecondaryStroke(this.getType());
    }

    @Override
    public Color getSecondaryStrokeColor() {
        return SettingsBean.getInstance().getAirspacesColorTheme().getAirspaceSecondaryColor(this.getType());
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AirspaceAreaDTO [id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", bottomAltitude=");
        builder.append(this.bottomAltitude);
        builder.append(", bottomAltitudeType=");
        builder.append((Object)this.bottomAltitudeType);
        builder.append(", topAltitude=");
        builder.append(this.topAltitude);
        builder.append(", topAltitudeType=");
        builder.append((Object)this.topAltitudeType);
        builder.append(", type=");
        builder.append((Object)this.type);
        builder.append(", origins=");
        builder.append(this.origins);
        builder.append("]");
        return builder.toString();
    }

    public MapShape toMapShape() {
        return super.clone();
    }

    @Override
    public int compareTo(AirspaceAreaDTO o) {
        if (this.topAltitude == null && o.getTopAltitude() == null) {
            return StringUtil.nullToEmpty(this.name).compareTo(StringUtil.nullToEmpty(o.getName()));
        }
        if (this.topAltitude != null && o.getTopAltitude() == null) {
            return -1;
        }
        if (this.topAltitude == null && o.getTopAltitude() != null) {
            return 1;
        }
        return this.topAltitude.compareTo(o.getTopAltitude());
    }

    public boolean containsPlaneAtAltitude(int alt) {
        if (this.topAltitude == null && this.bottomAltitude == null) {
            return true;
        }
        if (this.topAltitude != null && this.bottomAltitude != null) {
            return alt >= this.bottomAltitude && alt <= this.topAltitude;
        }
        if (this.topAltitude == null && this.bottomAltitude != null) {
            return alt >= this.bottomAltitude;
        }
        if (this.topAltitude != null && this.bottomAltitude == null) {
            return alt <= this.topAltitude;
        }
        return false;
    }
}

