/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.dto;

import java.util.ArrayList;
import main.java.guru.vfrflight.core.dto.ApronDTO;
import main.java.guru.vfrflight.core.dto.MapRunwayDTO;
import main.java.guru.vfrflight.core.dto.RunwayDTO;
import main.java.guru.vfrflight.core.dto.TaxiwayPathDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.AirportStart;
import main.java.guru.vfrflight.core.sql.entity.Apron;
import main.java.guru.vfrflight.core.sql.entity.Runway;
import main.java.guru.vfrflight.core.sql.entity.TaxiName;
import main.java.guru.vfrflight.core.sql.entity.Taxiway;
import main.java.guru.vfrflight.gui.map.NamedWaypoint;

public class AirportTaxiDTO {
    private GpsArea rectangleOver;
    private NamedWaypoint[] taxiNames;
    private ApronDTO[] aprons;
    private TaxiwayPathDTO[] taxiwayPaths;
    private NamedWaypoint[] starts;
    private MapRunwayDTO[] runways;

    public AirportTaxiDTO(Airport airport) {
        ArrayList<NamedWaypoint> tl = new ArrayList<NamedWaypoint>();
        for (TaxiName taxiName : airport.getTaxiNames()) {
            tl.add(new NamedWaypoint(taxiName));
        }
        if (tl.size() > 0) {
            this.taxiNames = tl.toArray(new NamedWaypoint[tl.size()]);
        }
        ArrayList<ApronDTO> al = new ArrayList<ApronDTO>();
        for (Apron apron : airport.getAprons()) {
            al.add(new ApronDTO(apron));
        }
        if (al.size() > 0) {
            this.aprons = al.toArray(new ApronDTO[al.size()]);
        }
        ArrayList<TaxiwayPathDTO> arrayList = new ArrayList<TaxiwayPathDTO>();
        for (Taxiway taxiway : airport.getTaxiways()) {
            arrayList.add(new TaxiwayPathDTO(taxiway));
        }
        if (arrayList.size() > 0) {
            this.taxiwayPaths = arrayList.toArray(new TaxiwayPathDTO[arrayList.size()]);
        }
        ArrayList<NamedWaypoint> arrayList2 = new ArrayList<NamedWaypoint>();
        for (AirportStart s : airport.getStarts()) {
            arrayList2.add(new NamedWaypoint(s));
        }
        if (arrayList2.size() > 0) {
            this.starts = arrayList2.toArray(new NamedWaypoint[arrayList2.size()]);
        }
        ArrayList<MapRunwayDTO> arrayList3 = new ArrayList<MapRunwayDTO>();
        for (Runway r : airport.getRunways()) {
            arrayList3.add(new MapRunwayDTO(new RunwayDTO(r)));
        }
        if (arrayList3.size() > 0) {
            this.runways = arrayList3.toArray(new MapRunwayDTO[arrayList3.size()]);
        }
    }

    public ApronDTO[] getAprons() {
        return this.aprons;
    }

    public void setAprons(ApronDTO[] aprons) {
        this.aprons = aprons;
    }

    public NamedWaypoint[] getTaxiNames() {
        return this.taxiNames;
    }

    public void setTaxiNames(NamedWaypoint[] taxiNames) {
        this.taxiNames = taxiNames;
    }

    public boolean hasTaxiNames() {
        return this.taxiNames != null && this.taxiNames.length > 0;
    }

    public boolean hasTaxiwayPaths() {
        return this.taxiwayPaths != null && this.taxiwayPaths.length > 0;
    }

    public boolean hasAprons() {
        return this.aprons != null && this.aprons.length > 0;
    }

    public boolean hasStarts() {
        return this.starts != null && this.starts.length > 0;
    }

    public boolean hasRunways() {
        return this.runways != null && this.runways.length > 0;
    }

    public NamedWaypoint[] getStarts() {
        return this.starts;
    }

    public void setStarts(NamedWaypoint[] starts) {
        this.starts = starts;
    }

    public GpsArea getRectangleOver() {
        if (this.rectangleOver == null) {
            this.rectangleOver = this.calculateRectangleOver();
        }
        return this.rectangleOver;
    }

    public GpsArea calculateRectangleOver() {
        GpsArea a;
        if (this.taxiNames == null && this.aprons == null && this.taxiwayPaths == null && this.runways == null) {
            return null;
        }
        double minLat = 500.0;
        double minLon = 500.0;
        double maxLat = -500.0;
        double maxLon = -500.0;
        if (this.taxiNames != null) {
            for (NamedWaypoint namedWaypoint : this.taxiNames) {
                if (namedWaypoint.getPosition().getLatitude() < minLat) {
                    minLat = namedWaypoint.getPosition().getLatitude();
                } else if (namedWaypoint.getPosition().getLatitude() > maxLat) {
                    maxLat = namedWaypoint.getPosition().getLatitude();
                }
                if (namedWaypoint.getPosition().getLongitude() < minLon) {
                    minLon = namedWaypoint.getPosition().getLongitude();
                    continue;
                }
                if (!(namedWaypoint.getPosition().getLongitude() > maxLon)) continue;
                maxLon = namedWaypoint.getPosition().getLongitude();
            }
        }
        if (this.aprons != null) {
            for (ApronDTO apronDTO : this.aprons) {
                a = apronDTO.getRectangleOver();
                if (a.getMinLat() < minLat) {
                    minLat = a.getMinLat();
                } else if (a.getMaxLat() > maxLat) {
                    maxLat = a.getMaxLat();
                }
                if (a.getMinLon() < minLon) {
                    minLon = a.getMinLon();
                    continue;
                }
                if (!(a.getMaxLon() > maxLon)) continue;
                maxLon = a.getMaxLon();
            }
        }
        if (this.taxiwayPaths != null) {
            for (TaxiwayPathDTO taxiwayPathDTO : this.taxiwayPaths) {
                a = taxiwayPathDTO.getRectangleOver();
                if (a == null) continue;
                if (a.getMinLat() < minLat) {
                    minLat = a.getMinLat();
                } else if (a.getMaxLat() > maxLat) {
                    maxLat = a.getMaxLat();
                }
                if (a.getMinLon() < minLon) {
                    minLon = a.getMinLon();
                    continue;
                }
                if (!(a.getMaxLon() > maxLon)) continue;
                maxLon = a.getMaxLon();
            }
        }
        if (this.runways != null) {
            for (MapRunwayDTO mapRunwayDTO : this.runways) {
                a = mapRunwayDTO.getRectangleOver();
                if (a == null) continue;
                if (a.getMinLat() < minLat) {
                    minLat = a.getMinLat();
                } else if (a.getMaxLat() > maxLat) {
                    maxLat = a.getMaxLat();
                }
                if (a.getMinLon() < minLon) {
                    minLon = a.getMinLon();
                    continue;
                }
                if (!(a.getMaxLon() > maxLon)) continue;
                maxLon = a.getMaxLon();
            }
        }
        return new GpsArea(maxLat, minLon, minLat, maxLon);
    }

    public void setRectangleOver(GpsArea rectangleOver) {
        this.rectangleOver = rectangleOver;
    }

    public boolean isInside(GpsArea area) {
        if (this.getRectangleOver() == null) {
            return false;
        }
        return this.rectangleOver.isInside(area) || area.isInside(this.rectangleOver);
    }

    public TaxiwayPathDTO[] getTaxiwayPaths() {
        return this.taxiwayPaths;
    }

    public void setTaxiwayPaths(TaxiwayPathDTO[] taxiwayPaths) {
        this.taxiwayPaths = taxiwayPaths;
    }

    public MapRunwayDTO[] getRunways() {
        return this.runways;
    }

    public void setRunways(MapRunwayDTO[] runways) {
        this.runways = runways;
    }
}

