/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.dto;

import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.type.AirportType;
import main.java.guru.vfrflight.gui.map.NamedWaypoint;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;
import main.java.org.jdesktop.swingx.mapviewer.Waypoint;

public class AirportDTO
extends NamedWaypoint
implements Waypoint {
    private Integer id;
    private String fullName;
    private Integer elevation;
    private Integer mainLength;
    private Integer mainRunwayDirection;
    private boolean ils;
    private boolean mountainous;
    private boolean vor;
    private boolean ndb;
    private boolean hasHeli;
    private boolean skewedIls;
    private boolean hardened;
    private AirportType type;

    public AirportDTO() {
    }

    public AirportDTO(Airport airport) {
        super(new GeoPosition(airport.getLat(), airport.getLon()), airport.getIdent());
        this.id = airport.getId();
        this.fullName = airport.getName();
        this.setElevation(airport.getElev());
        this.setMainLength(airport.getMainLength());
        this.setMainRunwayDirection(airport.getMainRwy());
        this.ils = airport.isIls();
        this.mountainous = airport.isMountainous();
        this.vor = airport.isVor();
        this.ndb = airport.isNdb();
        this.hasHeli = airport.isHeli();
        this.type = airport.getType();
        this.skewedIls = airport.isSkewedIls();
        this.hardened = airport.isHardened();
    }

    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        if (this.getName() != null) {
            sb.append(this.getName());
        } else if (this.getFullName() != null) {
            sb.append(this.getFullName());
        } else {
            sb.append("---");
        }
        if (this.elevation != null) {
            int elev = this.elevation;
            if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                elev = (int)UnitUtil.recalculateAltitude(elev, "ft", SettingsBean.getInstance().getParamUnitsAltitude(), true);
            }
            sb.append(" ");
            sb.append(elev);
            sb.append(SettingsBean.getInstance().getParamUnitsAltitude());
        }
        if (this.mainLength != null) {
            if (this.elevation != null) {
                sb.append(" - ");
            }
            sb.append(this.mainLength);
            sb.append("m");
        }
        return sb.toString();
    }

    @Override
    public GpsPlace getGpsPlace() {
        return new GpsPlace(new GpsCoord(this.getPosition().getLatitude()), new GpsCoord(this.getPosition().getLongitude()), this.getName(), this.elevation != null ? Double.valueOf(this.elevation.intValue()) : null);
    }

    public Integer getElevation() {
        return this.elevation;
    }

    public void setElevation(Integer elevation) {
        this.elevation = elevation;
    }

    public Integer getMainLength() {
        return this.mainLength;
    }

    public void setMainLength(Integer mainLength) {
        this.mainLength = mainLength;
    }

    public Integer getMainRunwayDirection() {
        return this.mainRunwayDirection;
    }

    public void setMainRunwayDirection(Integer mainRunwayDirection) {
        this.mainRunwayDirection = mainRunwayDirection;
    }

    public boolean isIls() {
        return this.ils;
    }

    public void setIls(boolean ils) {
        this.ils = ils;
    }

    public boolean isMountainous() {
        return this.mountainous;
    }

    public void setMountainous(boolean mountainous) {
        this.mountainous = mountainous;
    }

    public boolean isHardened() {
        return this.hardened;
    }

    public void setHardened(boolean hardened) {
        this.hardened = hardened;
    }

    public boolean isVor() {
        return this.vor;
    }

    public void setVor(boolean vor) {
        this.vor = vor;
    }

    public boolean isNdb() {
        return this.ndb;
    }

    public void setNdb(boolean ndb) {
        this.ndb = ndb;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getIdentOrName() {
        if (this.getName() != null) {
            return this.getName();
        }
        return this.fullName;
    }

    public boolean hasHeli() {
        return this.hasHeli;
    }

    public void setHasHeli(boolean hasHeli) {
        this.hasHeli = hasHeli;
    }

    public boolean isHeli() {
        return AirportType.HELI_CIVIL.equals((Object)this.type) || AirportType.HELI_MIL.equals((Object)this.type);
    }

    public boolean isSkewedIls() {
        return this.skewedIls;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AirportDTO [id=");
        builder.append(this.id);
        builder.append(", fullName=");
        builder.append(this.fullName);
        builder.append(", elevation=");
        builder.append(this.elevation);
        builder.append(", mainLength=");
        builder.append(this.mainLength);
        builder.append(", mainRunwayDirection=");
        builder.append(this.mainRunwayDirection);
        builder.append(", ils=");
        builder.append(this.ils);
        builder.append(", mountainous=");
        builder.append(this.mountainous);
        builder.append(", vor=");
        builder.append(this.vor);
        builder.append(", ndb=");
        builder.append(this.ndb);
        builder.append(", hasHeli=");
        builder.append(this.hasHeli);
        builder.append("]");
        return builder.toString();
    }
}

