/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.comparator;

import java.util.Comparator;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.TerrainMesh;
import main.java.guru.vfrflight.util.GpsUtil;

public class TerrainMeshDistanceComparator
implements Comparator<TerrainMesh> {
    private final GpsPlace point;

    public TerrainMeshDistanceComparator(GpsPlace point) {
        this.point = point;
    }

    @Override
    public int compare(TerrainMesh p1, TerrainMesh p2) {
        if (p1 == null && p2 == null) {
            return 0;
        }
        if (p1 == null && p2 != null) {
            return -1;
        }
        if (p1 != null && p2 == null) {
            return 1;
        }
        Double dist1 = GpsUtil.getDistance(this.point, p1.getRectangleOver().getCenter());
        Double dist2 = GpsUtil.getDistance(this.point, p2.getRectangleOver().getCenter());
        return dist1.compareTo(dist2);
    }
}

