/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.comparator;

import java.util.Comparator;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.util.VfrUtil;

public class MatchComparator
implements Comparator<GpsPlace> {
    private String match;

    public MatchComparator(String searchString) {
        this.match = searchString;
    }

    @Override
    public int compare(GpsPlace p1, GpsPlace p2) {
        if (p1 == null && p2 == null) {
            return 0;
        }
        if (p1 == null && p2 != null) {
            return -1;
        }
        if (p1 != null && p2 == null) {
            return 1;
        }
        double s1 = VfrUtil.calculateScore(p1.getName(), this.match);
        double s2 = VfrUtil.calculateScore(p2.getName(), this.match);
        if (s1 > 0.0 || s2 > 0.0) {
            if (s1 == s2) {
                return p1.getName().compareToIgnoreCase(p2.getName());
            }
            if (s1 > s2) {
                return -1;
            }
            return 1;
        }
        if (p1.getName() != null && p2.getName() != null) {
            return p1.getName().compareToIgnoreCase(p2.getName());
        }
        return 0;
    }

    public String getSearchString() {
        return this.match;
    }

    public void setSearchString(String searchString) {
        this.match = searchString;
    }
}

