/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.comparator;

import java.util.Comparator;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.LatLonObject;
import main.java.guru.vfrflight.util.GpsUtil;

public class LatLonDistanceComparator
implements Comparator<LatLonObject> {
    private final GpsPlace point;

    public LatLonDistanceComparator(GpsPlace point) {
        this.point = point;
    }

    @Override
    public int compare(LatLonObject p1, LatLonObject p2) {
        double dist2;
        boolean p2IsNull;
        boolean p1IsNull = p1 == null || p1.getLat() == null || p1.getLon() == null;
        boolean bl = p2IsNull = p2 == null || p2.getLat() == null || p2.getLon() == null;
        if (p1IsNull && p2IsNull) {
            return 0;
        }
        if (p1IsNull) {
            return -1;
        }
        if (p2IsNull) {
            return 1;
        }
        GpsPlace place1 = new GpsPlace(p1.getLat(), p1.getLon());
        GpsPlace place2 = new GpsPlace(p2.getLat(), p2.getLon());
        double dist1 = GpsUtil.getDistance(this.point, place1);
        if (dist1 == (dist2 = GpsUtil.getDistance(this.point, place2))) {
            return 0;
        }
        if (dist1 > dist2) {
            return -1;
        }
        return 1;
    }
}

