/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.comparator;

import java.util.Comparator;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.util.GpsUtil;

public class DistanceComparator
implements Comparator<GpsPlace> {
    private final GpsPlace point;

    public DistanceComparator(GpsPlace point) {
        this.point = point;
    }

    @Override
    public int compare(GpsPlace p1, GpsPlace p2) {
        double dist2;
        if (p1 == null && p2 == null) {
            return 0;
        }
        if (p1 == null && p2 != null) {
            return -1;
        }
        if (p1 != null && p2 == null) {
            return 1;
        }
        double dist1 = GpsUtil.getDistance(this.point, p1);
        if (dist1 == (dist2 = GpsUtil.getDistance(this.point, p2))) {
            return p1.getName().compareTo(p2.getName());
        }
        if (dist1 > dist2) {
            return -1;
        }
        return 1;
    }
}

