/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core.comparator;

import java.util.Comparator;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.util.GpsUtil;

public class AirportDistanceComparator
implements Comparator<Airport> {
    private final GpsPlace point;

    public AirportDistanceComparator(GpsPlace point) {
        this.point = point;
    }

    @Override
    public int compare(Airport p1, Airport p2) {
        double dist2;
        if (p1 == null && p2 == null) {
            return 0;
        }
        if (p1 == null && p2 != null) {
            return -1;
        }
        if (p1 != null && p2 == null) {
            return 1;
        }
        double dist1 = GpsUtil.getDistance(this.point, p1.getGpsPlace());
        if (dist1 == (dist2 = GpsUtil.getDistance(this.point, p2.getGpsPlace()))) {
            return p1.getName().compareTo(p2.getName());
        }
        if (dist1 > dist2) {
            return 1;
        }
        return -1;
    }
}

