/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core;

import main.java.guru.vfrflight.util.StringUtil;

public class SegmentLandmark
implements Comparable<SegmentLandmark> {
    private double position;
    private boolean selected = false;
    private int segmentIndex;
    private boolean minuteInterval = false;
    private String description;

    public SegmentLandmark(int segmentIndex, double position) {
        this.segmentIndex = segmentIndex;
        this.position = position;
    }

    public SegmentLandmark(int segmentIndex, double position, String description) {
        this(segmentIndex, position);
        this.description = description;
    }

    public double getPosition() {
        return this.position;
    }

    public void setPosition(double position) {
        this.position = position;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public int getSegmentIndex() {
        return this.segmentIndex;
    }

    public void setSegmentIndex(int segmentIndex) {
        this.segmentIndex = segmentIndex;
    }

    public boolean isMinuteInterval() {
        return this.minuteInterval;
    }

    public void setMinuteInterval(boolean minuteInterval) {
        this.minuteInterval = minuteInterval;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean hasDescription() {
        return !StringUtil.isEmpty(this.description);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SegmentLandmark [position=");
        builder.append(this.position);
        builder.append(", selected=");
        builder.append(this.selected);
        builder.append(", segmentIndex=");
        builder.append(this.segmentIndex);
        builder.append(", minuteInterval=");
        builder.append(this.minuteInterval);
        builder.append(", description=");
        builder.append(this.description);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.minuteInterval ? 1231 : 1237);
        long temp = Double.doubleToLongBits(this.position);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.segmentIndex;
        result = 31 * result + (this.selected ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SegmentLandmark other = (SegmentLandmark)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.minuteInterval != other.minuteInterval) {
            return false;
        }
        if (Double.doubleToLongBits(this.position) != Double.doubleToLongBits(other.position)) {
            return false;
        }
        if (this.segmentIndex != other.segmentIndex) {
            return false;
        }
        return this.selected == other.selected;
    }

    @Override
    public int compareTo(SegmentLandmark l) {
        if (l == null) {
            return -1;
        }
        return Double.valueOf(this.getPosition()).compareTo(l.getPosition());
    }
}

