/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core;

public class SceneryConfigEntry
implements Comparable<SceneryConfigEntry> {
    private String path;
    private int layer;
    private boolean active;
    private long size = 0L;
    private long fileCount = 0L;

    public SceneryConfigEntry(String path, int layer, boolean active) {
        this.path = path;
        this.layer = layer;
        this.active = active;
    }

    @Override
    public int compareTo(SceneryConfigEntry o) {
        if (this.layer < o.getLayer()) {
            return -1;
        }
        if (this.layer > o.getLayer()) {
            return 1;
        }
        return 0;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(long fileCount) {
        this.fileCount = fileCount;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.active ? 1231 : 1237);
        result = 31 * result + (int)(this.fileCount ^ this.fileCount >>> 32);
        result = 31 * result + this.layer;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SceneryConfigEntry other = (SceneryConfigEntry)obj;
        if (this.active != other.active) {
            return false;
        }
        if (this.fileCount != other.fileCount) {
            return false;
        }
        if (this.layer != other.layer) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return this.size == other.size;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SceneryConfigEntry [path=");
        builder.append(this.path);
        builder.append(", layer=");
        builder.append(this.layer);
        builder.append(", active=");
        builder.append(this.active);
        builder.append(", size=");
        builder.append(this.size);
        builder.append(", bglCount=");
        builder.append(this.fileCount);
        builder.append("]");
        return builder.toString();
    }
}

