/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.AlternateAirport;
import main.java.guru.vfrflight.core.FuelValues;
import main.java.guru.vfrflight.core.MapRadials;
import main.java.guru.vfrflight.core.MeteoReport;
import main.java.guru.vfrflight.core.SegmentLandmark;
import main.java.guru.vfrflight.core.WindSock;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.gps.RotatedGpsArea;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.core.gps.RouteSegment;
import main.java.guru.vfrflight.core.sql.entity.AirportStart;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.guru.vfrflight.weather.WeatherUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;
import org.apache.log4j.Logger;

public class Route {
    private static final Logger log = Logger.getLogger(Route.class);
    private String name;
    private String description;
    private List<RouteSegment> segments;
    private List<RoutePlace> vors;
    private List<MapRadials> mapRadials;
    private Double windDirection = 0.0;
    private Double windSpeed = 0.0;
    private Double cruiseSpeed;
    private Double climbingSpeed;
    private Double descendingSpeed;
    private Double cruiseAlt;
    private Long totalTime;
    private Double totalDistance;
    private Integer departureRwy;
    private AirportStart departurePosition;
    private boolean vfr = true;
    private Double Qmax;
    private Double Qm;
    private Double Qnav;
    private Double Qfl;
    private Double Qlft;
    private Double fuelBurn;
    private Double kzmax;
    private Integer navFuelReserveMin;
    private List<RoutePlace> points;
    private List<MeteoReport> meteoReports;
    private List<SegmentLandmark> landmarks;
    private List<AlternateAirport> alternateAirports;
    private WindSock windSock;
    private RotatedGpsArea pdfMapRegion;
    private Integer pdfMapZoom;
    private boolean mapResolutionAndAreaSelected = false;

    public boolean isEmpty() {
        if (!StringUtil.isEmpty(this.name)) {
            return false;
        }
        if (!StringUtil.isEmpty(this.description)) {
            return false;
        }
        if (this.getPoints().size() > 0 || this.getVors().size() > 0 || this.getMapRadials().size() > 0 || this.getLandmarks().size() > 0 || this.getAlternateAirports().size() > 0) {
            return false;
        }
        if (this.cruiseSpeed != null || this.climbingSpeed != null || this.descendingSpeed != null || this.cruiseAlt != null) {
            return false;
        }
        if (this.windDirection != null && NumberUtil.doubleGreaterThanZero(this.windDirection)) {
            return false;
        }
        return this.windSpeed == null || !NumberUtil.doubleGreaterThanZero(this.windSpeed);
    }

    public Route(String name) {
        this.name = name;
    }

    public List<RoutePlace> getPoints() {
        if (this.points == null) {
            this.points = new ArrayList<RoutePlace>();
        }
        return this.points;
    }

    public void setPoints(List<RoutePlace> points) {
        this.points = points;
    }

    public Double getMagvarFromCenter() {
        return VfrUtil.getMagneticDeclination(this.getCenter());
    }

    public GpsPlace getCenter() {
        return GpsUtil.getCenter(new ArrayList<GpsPlace>(this.getPoints()));
    }

    public void calculateSegments() {
        if (this.getPoints().size() < 1) {
            this.segments = new ArrayList<RouteSegment>();
        } else {
            this.segments = new ArrayList<RouteSegment>(this.getPoints().size() - 1);
            for (int i = 0; i < this.getPoints().size() - 1; ++i) {
                RoutePlace from = this.getPoints().get(i);
                RoutePlace to = this.getPoints().get(i + 1);
                RouteSegment segment = new RouteSegment(GpsUtil.getLineSegment(from, to));
                segment.setPhantom(to.isPhantom());
                if (segment.getCourse() != null) {
                    double magCrs = GpsUtil.normalizeCourse(segment.getCourse() - VfrUtil.getMagneticDeclination(segment));
                    segment.setMagneticCourse(magCrs);
                }
                this.segments.add(segment);
            }
        }
    }

    public double calculateTotalDistance() {
        double dist = 0.0;
        for (int i = 0; i < this.getPoints().size() - 1; ++i) {
            dist += GpsUtil.getDistance(this.getPoints().get(i), this.getPoints().get(i + 1));
        }
        return dist;
    }

    public List<RouteSegment> getSegments() {
        if (this.segments == null) {
            this.calculateSegments();
        }
        return this.segments;
    }

    public List<GpsPlace> getOnlyVors() {
        ArrayList<GpsPlace> vorsList = new ArrayList<GpsPlace>();
        for (GpsPlace gpsPlace : this.getVors()) {
            if (gpsPlace.isNdb()) continue;
            vorsList.add(gpsPlace);
        }
        return vorsList;
    }

    public List<RoutePlace> getVors() {
        if (this.vors == null) {
            this.vors = new ArrayList<RoutePlace>();
        }
        return this.vors;
    }

    public void setVors(List<RoutePlace> vors) {
        this.vors = vors;
    }

    public Double getCruiseAlt() {
        return this.cruiseAlt;
    }

    public void setCruiseAlt(Double cruiseAlt) {
        this.cruiseAlt = cruiseAlt;
    }

    public void setSegments(List<RouteSegment> segments) {
        this.segments = segments;
    }

    public Double getWindDirection() {
        return this.windDirection;
    }

    public void setWindDirection(Double windDirection) {
        this.windDirection = windDirection;
    }

    public Double getWindSpeed() {
        return this.windSpeed;
    }

    public void setWindSpeed(Double windSpeed) {
        this.windSpeed = windSpeed;
    }

    public Double getCruiseSpeed() {
        return this.cruiseSpeed;
    }

    public void setCruiseSpeed(Double cruiseSpeed) {
        this.cruiseSpeed = cruiseSpeed;
    }

    public Double getClimbingSpeed() {
        return this.climbingSpeed;
    }

    public void setClimbingSpeed(Double climbingSpeed) {
        this.climbingSpeed = climbingSpeed;
    }

    public Double getDescendingSpeed() {
        return this.descendingSpeed;
    }

    public void setDescendingSpeed(Double descendingSpeed) {
        this.descendingSpeed = descendingSpeed;
    }

    public Route() {
    }

    public Long getTotalTime() {
        return this.totalTime;
    }

    public void setTotalTime(Long totalTime) {
        this.totalTime = totalTime;
    }

    public Double getQmax() {
        return this.Qmax;
    }

    public void setQmax(Double qmax) {
        this.Qmax = qmax;
    }

    public Double getQm() {
        return this.Qm;
    }

    public void setQm(Double qm) {
        this.Qm = qm;
    }

    public Double getQnav() {
        return this.Qnav;
    }

    public void setQnav(Double qnav) {
        this.Qnav = qnav;
    }

    public Double getQfl() {
        return this.Qfl;
    }

    public void setQfl(Double qfl) {
        this.Qfl = qfl;
    }

    public Double getQlft() {
        return this.Qlft;
    }

    public void setQlft(Double qlft) {
        this.Qlft = qlft;
    }

    public Double getFuelBurn() {
        return this.fuelBurn;
    }

    public void setFuelBurn(Double fuelBurn) {
        this.fuelBurn = fuelBurn;
    }

    public Double getTotalDistance() {
        return this.totalDistance;
    }

    public void setTotalDistance(Double totalDistance) {
        this.totalDistance = totalDistance;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getDepartureRwy() {
        return this.departureRwy;
    }

    public void setDepartureRwy(Integer departureRwy) {
        this.departureRwy = departureRwy;
    }

    public AirportStart getDeparturePosition() {
        return this.departurePosition;
    }

    public void setDeparturePosition(AirportStart departurePosition) {
        this.departurePosition = departurePosition;
    }

    public boolean calculate() {
        if (this.cruiseSpeed == null) {
            if (!SettingsBean.getInstance().calculateRouteInRealTime()) {
                log.error("Cruise speed is missing");
            }
            return false;
        }
        if (this.windDirection == null || this.windSpeed == null) {
            if (!SettingsBean.getInstance().calculateRouteInRealTime()) {
                log.error("Wind information is missing");
            }
            return false;
        }
        this.calculateSegments();
        double Dn = this.windDirection;
        if (Dn >= 180.0) {
            Dn -= 180.0;
        }
        double windSpeedKt = this.windSpeed;
        if (!"kt".equals(SettingsBean.getInstance().getParamUnitsWindSpeed())) {
            windSpeedKt = UnitUtil.recalculateWindSpeed(this.windSpeed, SettingsBean.getInstance().getParamUnitsWindSpeed(), "kt", false);
        }
        double cruiseSpeedKt = this.cruiseSpeed;
        double climbingSpeedKt = this.climbingSpeed != null ? this.climbingSpeed : this.cruiseSpeed;
        double descendingSpeedKt = this.descendingSpeed != null ? this.descendingSpeed : this.cruiseSpeed;
        if (!"kt".equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
            cruiseSpeedKt = UnitUtil.recalculateSpeed(cruiseSpeedKt, SettingsBean.getInstance().getParamUnitsSpeed(), "kt", false);
            climbingSpeedKt = UnitUtil.recalculateSpeed(climbingSpeedKt, SettingsBean.getInstance().getParamUnitsSpeed(), "kt", false);
            descendingSpeedKt = UnitUtil.recalculateSpeed(descendingSpeedKt, SettingsBean.getInstance().getParamUnitsSpeed(), "kt", false);
        }
        this.kzmax = windSpeedKt * 60.0 / cruiseSpeedKt;
        this.totalTime = 0L;
        this.totalDistance = 0.0;
        for (int i = 0; i < this.getSegments().size(); ++i) {
            RouteSegment segment = this.getSegments().get(i);
            if (segment.getCourse() == null) continue;
            double speed = cruiseSpeedKt;
            if (segment.getFrom().getAlt() != null && segment.getTo().getAlt() != null) {
                double to;
                double from = NumberUtil.roundDouble(segment.getFrom().getAlt(), 3);
                if (from < (to = NumberUtil.roundDouble(segment.getTo().getAlt(), 3))) {
                    speed = climbingSpeedKt;
                } else if (from > to) {
                    speed = descendingSpeedKt;
                }
            }
            double Kz = VfrUtil.calculateWindCorectionAngle(speed, segment.getCourse(), windSpeedKt, this.windDirection);
            double gs = VfrUtil.calculateGSForWind(speed, segment.getCourse(), windSpeedKt, this.windDirection);
            segment.setW(UnitUtil.recalculateSpeed(gs, "kt", SettingsBean.getInstance().getParamUnitsSpeed(), false));
            segment.setKz(Kz);
            long t = Math.round(segment.getDistance() / gs * 3600.0);
            segment.setT(t);
            this.totalTime = this.totalTime + t;
            segment.setEta(this.totalTime);
            this.totalDistance = this.totalDistance + segment.getDistance();
            if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
                segment.setDistance(UnitUtil.recalculateDistance(segment.getDistance(), "nm", SettingsBean.getInstance().getParamUnitsDistance(), false));
            }
            if (SettingsBean.getInstance().calculateRouteInRealTime()) continue;
            log.debug(segment + "; ETA= " + Math.round((double)this.totalTime.longValue() / 60.0) + "m");
        }
        if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
            this.totalDistance = UnitUtil.recalculateDistance(this.totalDistance, "nm", SettingsBean.getInstance().getParamUnitsDistance(), false);
        }
        if (this.fuelBurn != null) {
            this.Qnav = this.navFuelReserveMin != null ? NumberUtil.roundDouble(this.fuelBurn * (double)this.navFuelReserveMin.intValue() / 60.0, 1) : 0.0;
            this.Qfl = NumberUtil.roundDouble((double)this.totalTime.longValue() / 3600.0 * this.fuelBurn, 1);
            if (this.Qm == null) {
                this.Qm = 0.0;
            }
            this.Qlft = this.Qmax != null ? Double.valueOf(NumberUtil.roundDouble(this.Qmax - this.Qfl - this.Qnav - this.Qm, 1)) : Double.valueOf(0.0);
            if (!SettingsBean.getInstance().isCalculateRouteInRealTime()) {
                log.debug("FUEL: Qnav= " + this.Qnav + "l, Qfl= " + this.Qfl + "l, Qlft= " + this.Qlft + "l");
            }
        }
        if (!SettingsBean.getInstance().isCalculateRouteInRealTime()) {
            log.debug("TotalTime: " + Math.round((double)this.totalTime.longValue() / 60.0) + "m, totalDistance: " + (double)Math.round(this.totalDistance * 10.0) / 10.0 + "nm");
        }
        return true;
    }

    public void calculateMinuteIntervals(int min) {
        double sec = (double)min * 60.0;
        this.clearMinuteIntervals();
        for (int i = 0; i < this.getSegments().size(); ++i) {
            RouteSegment segment = this.getSegments().get(i);
            if (!((double)segment.getT() > sec)) continue;
            double posInterval = sec / (double)segment.getT();
            int q = 1;
            while ((double)q <= Math.floor((double)segment.getT() / sec)) {
                SegmentLandmark landmark = new SegmentLandmark(i, posInterval * (double)q);
                landmark.setMinuteInterval(true);
                this.getLandmarks().add(landmark);
                ++q;
            }
        }
    }

    public void clearMinuteIntervals() {
        Iterator<SegmentLandmark> it = this.getLandmarks().iterator();
        while (it.hasNext()) {
            if (!it.next().isMinuteInterval()) continue;
            it.remove();
        }
    }

    public Map<String, LineSegment> getVorRadials(GpsPlace place) {
        TreeMap<String, LineSegment> res = new TreeMap<String, LineSegment>();
        if (this.getOnlyVors().size() > 0) {
            for (GpsPlace vor : this.getOnlyVors()) {
                res.put(vor.getName(), GpsUtil.getVorRadial(vor, place));
            }
        }
        return res;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FuelValues getFuelValues() {
        return new FuelValues(this.Qmax, this.Qm, this.Qnav, this.Qfl, this.Qlft);
    }

    public boolean isFuelInfo() {
        return this.fuelBurn != null && this.Qmax != null && this.Qm != null;
    }

    public boolean addMeteoReport(GpsPlace place, double distanceEnRoute) {
        BufferedImage meteo = WeatherUtil.getMeteo(place, SettingsBean.getInstance().getLanguageCode().toLowerCase());
        if (meteo != null) {
            this.getMeteoReports().add(new MeteoReport(place, meteo, distanceEnRoute));
            return true;
        }
        return false;
    }

    public List<MeteoReport> getMeteoReports() {
        if (this.meteoReports == null) {
            this.meteoReports = new ArrayList<MeteoReport>();
        }
        return this.meteoReports;
    }

    public void setMeteoReports(List<MeteoReport> meteoReports) {
        this.meteoReports = meteoReports;
    }

    public List<SegmentLandmark> getLandmarks() {
        if (this.landmarks == null) {
            this.landmarks = new ArrayList<SegmentLandmark>();
        }
        return this.landmarks;
    }

    public void setLandmarks(List<SegmentLandmark> landmarks) {
        this.landmarks = landmarks;
    }

    public List<GpsPlace> getLandmarkPlacesForAllSegments(JXMapViewer map) {
        this.calculateSegments();
        ArrayList<GpsPlace> result = new ArrayList<GpsPlace>();
        for (SegmentLandmark landmark : this.getLandmarks()) {
            LineSegment segment = this.getSegments().get(landmark.getSegmentIndex());
            GpsPlace pos = GpsUtil.getPointPositionByDistanceAndBearing(segment.getFrom(), segment.getCourse(), segment.getDistance() * landmark.getPosition());
            result.add(GpsUtil.getGpsPlaceOnSegment(map, segment, pos));
        }
        return result;
    }

    public List<GpsPlace> getLandmarkPlacesForSegment(JXMapViewer map, int segmentIndex) {
        this.calculateSegments();
        if (segmentIndex >= 0 && segmentIndex < this.getSegments().size()) {
            LineSegment segment = this.getSegments().get(segmentIndex);
            ArrayList<GpsPlace> result = new ArrayList<GpsPlace>();
            for (SegmentLandmark landmark : this.getLandmarks()) {
                if (landmark.getSegmentIndex() != segmentIndex) continue;
                GpsPlace pos = GpsUtil.getPointPositionByDistanceAndBearing(segment.getFrom(), segment.getCourse(), segment.getDistance() * landmark.getPosition());
                result.add(GpsUtil.getGpsPlaceOnSegment(map, segment, pos));
            }
            return result;
        }
        return null;
    }

    public GpsPlace getLandmarkPlaceForSegment(JXMapViewer map, int segmentIndex, int landmarkIndex) {
        if (segmentIndex >= 0 && segmentIndex < this.getSegments().size() && landmarkIndex >= 0) {
            LineSegment segment = this.getSegments().get(segmentIndex);
            if (landmarkIndex < this.getLandmarks().size()) {
                int idx = 0;
                for (SegmentLandmark landmark : this.getLandmarks()) {
                    if (landmark.getSegmentIndex() != segmentIndex) continue;
                    if (idx == landmarkIndex) {
                        GpsPlace pos = GpsUtil.getPointPositionByDistanceAndBearing(segment.getFrom(), segment.getCourse(), segment.getDistance() * landmark.getPosition());
                        return GpsUtil.getGpsPlaceOnSegment(map, segment, pos);
                    }
                    ++idx;
                }
            }
        }
        return null;
    }

    public List<SegmentLandmark> getLandmarksForSegment(int segmentIndex) {
        ArrayList<SegmentLandmark> landmarks = new ArrayList<SegmentLandmark>();
        for (SegmentLandmark landmark : this.getLandmarks()) {
            if (landmark.getSegmentIndex() != segmentIndex) continue;
            landmarks.add(landmark);
        }
        Collections.sort(landmarks);
        return landmarks;
    }

    public WindSock getWindSock() {
        if (this.windSock == null) {
            this.windSock = new WindSock();
        }
        return this.windSock;
    }

    public void setWindSock(WindSock windSock) {
        this.windSock = windSock;
    }

    public void addPhantomVor(RoutePlace phantomVor) {
        this.removePhantomVors();
        phantomVor.setPhantom(true);
        this.getVors().add(phantomVor);
    }

    public boolean removePhantomVors() {
        boolean result = false;
        Iterator<RoutePlace> iter = this.getVors().iterator();
        while (iter.hasNext()) {
            if (!iter.next().isPhantom()) continue;
            iter.remove();
            result = true;
        }
        return result;
    }

    public void addPhantomPoint(RoutePlace phantomPoint) {
        this.removePhantomPoints();
        phantomPoint.setPhantom(true);
        this.getPoints().add(phantomPoint);
    }

    public boolean removePhantomPoints() {
        boolean result = false;
        Iterator<RoutePlace> iter = this.getPoints().iterator();
        while (iter.hasNext()) {
            if (!iter.next().isPhantom()) continue;
            iter.remove();
            result = true;
        }
        return result;
    }

    public Route clone() {
        Route route = new Route();
        route.setCruiseAlt(this.cruiseAlt);
        route.setCruiseSpeed(this.cruiseSpeed);
        route.setDepartureRwy(this.departureRwy);
        route.setDeparturePosition(this.departurePosition);
        route.setVfr(this.vfr);
        route.setDescription(this.description);
        route.setFuelBurn(this.fuelBurn);
        route.setLandmarks((List<SegmentLandmark>)(this.landmarks != null ? new ArrayList<SegmentLandmark>(this.landmarks) : null));
        route.setMeteoReports((List<MeteoReport>)(this.meteoReports != null ? new ArrayList<MeteoReport>(this.meteoReports) : null));
        route.setName(this.name);
        route.setPoints((List<RoutePlace>)(this.points != null ? new ArrayList<RoutePlace>(this.points) : null));
        route.setQfl(this.Qfl);
        route.setQlft(this.Qlft);
        route.setQm(this.Qm);
        route.setQmax(this.Qmax);
        route.setQnav(this.Qnav);
        route.setSegments((List<RouteSegment>)(this.segments != null ? new ArrayList<RouteSegment>(this.segments) : null));
        route.setTotalDistance(this.totalDistance);
        route.setTotalTime(this.totalTime);
        route.setVors((List<RoutePlace>)(this.vors != null ? new ArrayList<RoutePlace>(this.vors) : null));
        route.setMapRadials((List<MapRadials>)(this.mapRadials != null ? new ArrayList<MapRadials>(this.mapRadials) : null));
        route.setWindDirection(this.windDirection);
        route.setWindSock(this.windSock != null ? this.windSock.clone() : null);
        route.setWindSpeed(this.windSpeed);
        route.setKzmax(this.kzmax);
        return route;
    }

    public Double getKzmax() {
        return this.kzmax;
    }

    public void setKzmax(Double kzmax) {
        this.kzmax = kzmax;
    }

    public List<MapRadials> getMapRadials() {
        if (this.mapRadials == null) {
            this.mapRadials = new ArrayList<MapRadials>();
        }
        return this.mapRadials;
    }

    public void setMapRadials(List<MapRadials> mapRadials) {
        this.mapRadials = mapRadials;
    }

    public boolean isVfr() {
        return this.vfr;
    }

    public void setVfr(boolean vfr) {
        this.vfr = vfr;
    }

    public boolean containsPoint(String name) {
        for (GpsPlace gpsPlace : this.getPoints()) {
            if (!gpsPlace.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean couldBeCalculateInRealTime() {
        return this.getCruiseSpeed() != null;
    }

    public RotatedGpsArea getPdfMapRegion() {
        return this.pdfMapRegion;
    }

    public void setPdfMapRegion(RotatedGpsArea pdfMapRegion) {
        this.pdfMapRegion = pdfMapRegion;
    }

    public Integer getPdfMapZoom() {
        return this.pdfMapZoom;
    }

    public void setPdfMapZoom(Integer pdfMapZoom) {
        this.pdfMapZoom = pdfMapZoom;
    }

    public Integer getNavFuelReserveMin() {
        return this.navFuelReserveMin;
    }

    public void setNavFuelReserveMin(Integer navFuelReserveMin) {
        this.navFuelReserveMin = navFuelReserveMin;
    }

    public boolean containsAlternateAirports(GpsPlace place) {
        for (AlternateAirport a : this.getAlternateAirports()) {
            if (place.getName() == null || !place.getName().equals(a.getIdent()) || !(GpsUtil.getDistance(place, a.getGpsPlace()) <= 0.5)) continue;
            return true;
        }
        return false;
    }

    public List<AlternateAirport> getAlternateAirports() {
        if (this.alternateAirports == null) {
            this.alternateAirports = new ArrayList<AlternateAirport>();
        }
        return this.alternateAirports;
    }

    public void setAlternateAirports(List<AlternateAirport> alternateAirports) {
        this.alternateAirports = alternateAirports;
    }

    public List<LineSegment> getLineSegments() {
        ArrayList<LineSegment> segments = new ArrayList<LineSegment>();
        for (RouteSegment segment : this.getSegments()) {
            segments.add(segment);
        }
        return segments;
    }

    public List<GpsPlace> getClosestVorPlacesByDistance(GpsPlace place) {
        List<GpsPlace> vors = this.getOnlyVors();
        HashMap<Double, GpsPlace> radials = new HashMap<Double, GpsPlace>();
        for (GpsPlace vor : vors) {
            double dist = GpsUtil.getDistance(vor, place);
            radials.put(dist, vor);
        }
        ArrayList<GpsPlace> res = new ArrayList<GpsPlace>();
        ArrayList keys = new ArrayList(radials.keySet());
        Collections.sort(keys);
        for (Double key : keys) {
            for (GpsPlace vor : vors) {
                if (!((GpsPlace)radials.get(key)).equals(vor)) continue;
                res.add(vor);
            }
        }
        return res;
    }

    public List<LineSegment> getTwoRadialsFromClosestVors(GpsPlace place, double maxDist) {
        HashMap<Double, LineSegment> radials = new HashMap<Double, LineSegment>();
        for (GpsPlace vor : this.getOnlyVors()) {
            double dist = GpsUtil.getDistance(vor, place);
            if (!(dist <= maxDist)) continue;
            radials.put(dist, GpsUtil.getVorRadial(vor.clone(), place.clone()));
        }
        ArrayList<LineSegment> res = new ArrayList<LineSegment>();
        ArrayList keys = new ArrayList(radials.keySet());
        Collections.sort(keys);
        int i = 0;
        for (Double key : keys) {
            res.add((LineSegment)radials.get(key));
            if (++i < 2) continue;
            break;
        }
        return res;
    }

    public List<String> getClosestVorsInfoByDistance(GpsPlace place) {
        HashMap<Double, String> radials = new HashMap<Double, String>();
        for (GpsPlace vor : this.getOnlyVors()) {
            double dist = GpsUtil.getDistance(vor, place);
            radials.put(dist, vor.getName() + " " + FormatUtil.formatRadial(GpsUtil.getVorRadial(vor, place), true, true));
        }
        ArrayList<String> res = new ArrayList<String>();
        ArrayList keys = new ArrayList(radials.keySet());
        Collections.sort(keys);
        for (Double key : keys) {
            res.add((String)radials.get(key));
        }
        return res;
    }

    public String getFormattedTwoClosestVors(GpsPlace place, String delimiter) {
        List<String> vors = this.getClosestVorsInfoByDistance(place);
        if (vors.size() == 1) {
            return vors.get(0);
        }
        if (vors.size() >= 2) {
            return vors.get(0) + delimiter + vors.get(1);
        }
        return "";
    }

    public boolean isMapResolutionAndAreaSelected() {
        return this.mapResolutionAndAreaSelected;
    }

    public void setMapResolutionAndAreaSelected(boolean mapResolutionAndAreaSelected) {
        this.mapResolutionAndAreaSelected = mapResolutionAndAreaSelected;
    }
}

