/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core;

import java.awt.Color;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.sql.type.MapObjectType;
import main.java.guru.vfrflight.gui.map.shape.MapShape;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class MouseCursorInfo
implements Comparable<MouseCursorInfo> {
    public static final MouseCursorInfo BREAK_LINE = new MouseCursorInfo(true);
    private String text;
    private Color color = Color.BLACK;
    private Color backgroundColor = null;
    private MapObjectType type;
    private GeoPosition position;
    private MapShape shape;
    private boolean breakLine = false;

    public MouseCursorInfo(GeoPosition position, MapShape shape, String text, Color color) {
        this.position = position;
        this.shape = shape;
        this.text = text;
        this.color = color;
    }

    public MouseCursorInfo(GeoPosition position, MapShape shape, MapObjectType type, String text, Color color) {
        this(position, shape, text, color);
        this.type = type;
    }

    public MouseCursorInfo(GeoPosition position, MapShape shape, MapObjectType type, String text, Color color, Color backgroundColor) {
        this(position, shape, type, text, color);
        this.backgroundColor = backgroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color strokeColor) {
        this.backgroundColor = strokeColor;
    }

    public MapObjectType getType() {
        return this.type;
    }

    public void setType(MapObjectType type) {
        this.type = type;
    }

    public MouseCursorInfo clone() {
        return new MouseCursorInfo(this.position, this.shape, this.type, this.text, this.color, this.backgroundColor);
    }

    public GeoPosition getPosition() {
        return this.position;
    }

    public void setPosition(GeoPosition position) {
        this.position = position;
    }

    public MapShape getShape() {
        return this.shape;
    }

    public void setShape(MapShape shape) {
        this.shape = shape;
    }

    public boolean isShape() {
        return !this.breakLine && this.shape != null;
    }

    public boolean isPoint() {
        return !this.breakLine && this.position != null;
    }

    public boolean isInside(GpsArea area) {
        if (this.isPoint()) {
            return this.getPosition().getLatitude() <= area.getMaxLat() && this.getPosition().getLatitude() >= area.getMinLat() && this.getPosition().getLongitude() >= area.getMinLon() && this.getPosition().getLongitude() <= area.getMaxLon();
        }
        return this.shape.getRectangleOver().isInside(area) || area.isInside(this.shape.getRectangleOver());
    }

    @Override
    public int compareTo(MouseCursorInfo o) {
        if (o == null) {
            return -1;
        }
        if (o.getType() == null && this.getType() == null) {
            return 0;
        }
        if (o.getType() == null && this.getType() != null) {
            return -1;
        }
        if (o.getType() != null && this.getType() == null) {
            return 1;
        }
        if (o.getType().ordinal() == this.getType().ordinal()) {
            return this.getText().compareTo(o.getText());
        }
        return o.getType().ordinal() > this.getType().ordinal() ? -1 : 1;
    }

    public boolean isBreakLine() {
        return this.breakLine;
    }

    public void setBreakLine(boolean breakLine) {
        this.breakLine = breakLine;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public MouseCursorInfo(boolean breakLine) {
        this.breakLine = breakLine;
    }
}

