/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core;

import java.util.Collection;
import java.util.LinkedList;

public class FifoQueue<E>
extends LinkedList<E> {
    private static final long serialVersionUID = -153911141572030930L;
    private int maxNumberOfElements;

    public int getMaxNumberOfElements() {
        return this.maxNumberOfElements;
    }

    public void setMaxNumberOfElements(int maxNumberOfElements) {
        this.maxNumberOfElements = maxNumberOfElements;
    }

    public FifoQueue(int maxNumberOfElements) {
        this.maxNumberOfElements = maxNumberOfElements;
    }

    @Override
    public boolean add(E e) {
        if (super.add(e)) {
            this.removeOverLimit();
            return true;
        }
        return false;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        this.removeOverLimit();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (super.addAll(c)) {
            this.removeOverLimit();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (super.addAll(c)) {
            this.removeOverLimit();
            return true;
        }
        return false;
    }

    @Override
    public void addFirst(E e) {
        super.addFirst(e);
        this.removeOverLimit();
    }

    @Override
    public void addLast(E e) {
        super.addLast(e);
        this.removeOverLimit();
    }

    private void removeOverLimit() {
        int num = this.size() - this.maxNumberOfElements;
        for (int q = 0; q < num; ++q) {
            this.removeFirst();
        }
    }
}

