/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core;

import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.UnitUtil;

public class DesiredVector {
    private final Double magneticHeading;
    private final Long time;
    private final Double distanceNm;

    public DesiredVector(Double magneticHeading, Long time, Double distanceNm) {
        this.magneticHeading = magneticHeading;
        this.time = time;
        this.distanceNm = distanceNm;
    }

    public Double getMagneticHeading() {
        return this.magneticHeading;
    }

    public Long getTime() {
        return this.time;
    }

    public Double getDistanceNm() {
        return this.distanceNm;
    }

    public String getInfo() {
        double dist = this.distanceNm;
        if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
            dist = UnitUtil.recalculateDistance(this.distanceNm, "nm", SettingsBean.getInstance().getParamUnitsDistance(), false);
        }
        return "MH" + FormatUtil.formattedCourse(this.magneticHeading, false) + " / " + FormatUtil.formatTimeLandmark(this.time.longValue(), SettingsBean.getInstance().isParamIncludeSecondsInTimeCalculations()) + " / " + Math.round(dist) + SettingsBean.getInstance().getParamUnitsDistance();
    }
}

